<?php

/**
 * Checks if there is a non-virtual robots.txt file and if yes, show it.
 *
 * @package Health Check
 */

// Make sure the file is not directly accessible.
if ( ! defined( 'ABSPATH' ) ) {
	die( 'We\'re sorry, but you can not directly access this file.' );
}

/**
 * Class Mail Check
 */
class Health_Check_Robotstxt extends Health_Check_Tool {

	public function __construct() {
		$this->label       = __( 'robots.txt Viewer', 'health-check' );
		$this->description = __( 'The <code>robots.txt</code> file tells search engines which folders are allowed to crawl and which not. WordPress generates a virtual files if there is no physical file. If there is a non-virtual file, the content is shown here.', 'health-check' );

		parent::__construct();
	}

	public function tab_content() {
		global $wp_rewrite;

		if ( file_exists( ABSPATH . 'robots.txt' ) ) {
			printf(
				'<pre>%s</pre>',
				esc_html( file_get_contents( ABSPATH . 'robots.txt' ) )
			);
		} else {
			printf(
				'<p>%s</p>',
				__( 'Your site is using the virtual <code>robots.txt</code> file which is generated by WordPress.', 'health-check' )
			);
		}
		?>
		<?php
	}

}

new Health_Check_Robotstxt();
