<?php get_header();?>
<?php 
	
	$options = get_option('wp_dastak'.'_theme_options');
	$sidebar = sh_set( $options, 'blog_pages_sidebar');
	$layout = sh_set($options, 'blog_sidebar_layout');
?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo (sh_set( $options, 'blog_header_banner')) ? 'style="background-image:url('.sh_set( $options, 'blog_header_banner').'");' : '';?>></div> 
		<div class="container">
			<div class="inner-head">
				<div class="inner-title">
					<h2><?php
						if ( is_day() ) :
							printf( __( '<i>Daily</i> Archives: %s', 'wp_dastak' ), get_the_date() );
						elseif ( is_month() ) :
							printf( __( '<i>Monthly</i> Archives: %s', 'wp_dastak' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'wp_dastak' ) ) );
						elseif ( is_year() ) :
							printf( __( '<i>Yearly</i> Archives: %s', 'wp_dastak' ), get_the_date( _x( 'Y', 'yearly archives date format', 'wp_dastak' ) ) );
						else :
							_e( 'Archives', 'wp_dastak' );
						endif;
					?></h2>
                    <?php if(sh_set( $options, 'blog_page_subtitle')):?>
                        <span><?php echo sh_set( $options, 'blog_page_subtitle'); ?></span>
                    <?php endif;?>
				</div>
				<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section>



<section class="block">
	<div class="container">
		<div class="row">
        	<?php if($sidebar && $layout == 'left'):?>
            	
                <aside class="col-md-3 slideinright">
                	 <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            
            <?php endif;?>
            
			<div class="<?php echo ($layout == 'full' || $layout == '') ? 'col-md-12' : 'col-md-9';?>">
				<div class="inner-left">
					
                    <?php get_template_part('content', 'blog'); ?>
                    <?php _the_pagination(); ?>
				</div><!-- Inner left Sec  -->
			</div>
            
            <?php if($sidebar && $layout == 'right'){?>
            	
                <aside class="col-md-3 slideinright">
                	 <?php dynamic_sidebar( $sidebar ); ?>
                </aside>
            
            <?php }?>
			
		</div>
	</div>
</section>


<?php get_footer();?>