<?php
/* Template Name: Forgot Password */

if( is_user_logged_in() ) 
{
	wp_redirect( home_url() );
	exit;
}

get_header();?>
<?php $meta_settings  = get_post_meta(get_the_ID(), 'sh_page_meta', true);?>
<?php $meta_values = $meta_settings['sh_post_options'];?>
<?php //echo printr($meta_values );?>
<?php $settings = get_option( 'wp_dastak'.'_theme_options' );//printr($settings);?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo (sh_get_meta_value(get_the_ID(), 'header_image')) ? 'style="background-image:url('.sh_get_meta_value(get_the_ID(), 'header_image').');"' : '';?>></div> 
		<div class="container">
			<div class="inner-head">
				<div class="inner-title">
					<h2><?php echo (sh_get_meta_value(get_the_ID(), 'banner_title')) ? sh_get_meta_value(get_the_ID(), 'banner_title') : get_the_title(get_the_ID());?></h2>
					<span><?php echo sh_get_meta_value(get_the_ID(), 'sub_title'); ?></span>
				</div>
				<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section>

<section class="block register-sec" <?php echo (sh_set($settings, 'forgot_password_image')) ? 'style="background-image:url('.sh_set($settings, 'forgot_password_image').'");' : '';?>>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="register-form">
                    <div class="row">
                        <?php do_action('lost_password'); ?>
                        <h3><?php _e('Lost Password', 'wp_dastak');?></h3>
                        
                            <form action="<?php echo wp_lostpassword_url( esc_url(get_permalink()) ); ?>" method="post">
                                <div class="col-md-12">   
                                    <div class="fields">
                                        <i class="fa fa-envelope-o"></i><input type="text" name="user_login" id="user_login"  placeholder="<?php _e('Username or E-mail', 'wp_dastak');?>" value="<?php echo esc_attr(sh_set($_POST, 'user_login')); ?>" size="20" />
                                   </div>
                               </div>
                               <div class="col-md-12">  
                                    <div class="submit-form">
                                        <input type="hidden" name="redirect_to" value="<?php echo esc_url( get_permalink() ); ?>" />
                                        <input type="submit" name="wp-submit" id="wp-submit" class="btn btn-cyan" value="<?php _e('Get New Password', 'wp_dastak'); ?>" />
                                        <p><?php _e('Please enter your username or email address. You will receive a link to create a new password via email.', 'wp_dastak');?></p>
                                    </div>
                               </div>
                            </form>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php get_footer(); ?>