<?php
define('DOMAIN', 'wp_dastak');
define('SH_NAME', 'wp_dastak');
define('SH_VERSION', 'v1.0.1');
define('SH_ROOT', get_template_directory() . '/');
define('SH_URL', get_template_directory_uri() . '/');
define('SH_DIR', dirname(__FILE__));
define('THEME_PREFIX', 'SH_');

get_template_part('includes/loader');

add_action('after_setup_theme', 'sh_theme_setup');

function sh_theme_setup() {
    global $wp_version;

    load_theme_textdomain('wp_dastak', get_template_directory() . '/languages');

    add_editor_style();

    //ADD THUMBNAIL SUPPORT
    add_theme_support('woocommerce');
    add_theme_support('post-thumbnails');
    add_theme_support('menus'); //Add menu support
    add_theme_support('automatic-feed-links'); //Enables post and comment RSS feed links to head.
    add_theme_support('widgets'); //Add widgets and sidebar support
    add_theme_support('post-formats', array('video', 'audio', 'gallery', 'image', 'slideshow'));
    add_theme_support("custom-header");
    add_theme_support("custom-background");
    add_theme_support("title-tag");

    /** Register wp_nav_menus */
    if (function_exists('register_nav_menu')) {
        register_nav_menus(
            array(
                /** Register Main Menu location header */
                'main_menu' => __('Main Menu', 'wp_dastak'),
                'footer_menu' => __('Footer Menu', 'wp_dastak'),
            )
        );
    }

    if (!isset($content_width))
        $content_width = 960;

    add_image_size('370x370', 370, 370, true);
    add_image_size('870x347', 870, 347, true);
    add_image_size('370x220', 370, 220, true);
    add_image_size('370x337', 370, 337, true);
    add_image_size('284x216', 284, 216, true);
    add_image_size('570x350', 570, 350, true);
    add_image_size('289x359', 289, 359, true);
    add_image_size('273x197', 273, 197, true);
    add_image_size('273x395', 273, 395, true);
    add_image_size('370x480', 370, 480, true);
    add_image_size('570x195', 570, 195, true);
    add_image_size('570x519', 570, 519, true);
    //add_image_size('1170x467', 1170, 467, true);
}

function sh_theme_activation_hook($oldname, $oldtheme = false) {
    $options = get_option('wp_dastak');
    if (!$options) {
        $content = '';
        ob_start();

        include('includes/backup/theme_options/default_settings');
        $content = ob_get_contents();
        $content = unserialize(base64_decode($content));

        ob_end_clean();
        if ($content)
            update_option('wp_dastak', $content);
    }
}

add_action("after_switch_theme", "sh_theme_activation_hook", 10, 2);

function sh_widget_init() {
    global $wp_registered_sidebars;
    register_widget("SH_feedburner");
    register_widget("SH_Recent_Post");
    register_widget("SH_Testimonials");
    register_widget("SH_Our_Office");
    register_widget("SH_Recent_Work");
    register_widget("SH_Flickr");
    register_widget("SH_twitter");
    register_widget("SH_post_categories_list");
    register_widget("SH_galleries_list");



    register_sidebar(array(
        'name' => __('Default Sidebar', 'wp_dastak'),
        'id' => 'default-sidebar',
        'description' => __('Widgets in this area will be shown on the right-hand side.', 'wp_dastak'),
        'class' => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<div class="heading2"><h2>',
        'after_title' => '</h2></div>'
    ));

    register_sidebar(array(
        'name' => __('Blog Listing', 'wp_dastak'),
        'id' => 'blog-sidebar',
        'description' => __('Widgets in this area will be shown on the right-hand side.', 'wp_dastak'),
        'class' => '',
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h2>',
        'after_title' => '</h2>'
    ));

    register_sidebar(array(
        'name' => __('Footer Sidebar', 'wp_dastak'),
        'id' => 'footer-sidebar',
        'description' => __('Widgets in this area will be shown on the right-hand side.', 'wp_dastak'),
        'class' => 'quick-menu',
        'before_widget' => '<div id="%1$s" class="widget col-md-3 %2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    //printr(get_option('wp_dastak'.'_theme_options'));
    $sidebars = sh_set(get_option('wp_dastak' . '_theme_options'), 'dynamic_sidebar'); //printr($sidebars);
    foreach (array_filter((array) sh_set($sidebars, 'dynamic_sidebar')) as $sidebar) {
        if (sh_set($sidebar, 'sidebar_name') != '') {
            register_sidebar(array(
                'name' => sh_set($sidebar, 'sidebar_name'),
                'id' => bistro_slug(sh_set($sidebar, 'sidebar_name')),
                'before_widget' => '<div id="%1$s" class="widget %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<div class="heading2"><h2>',
                'after_title' => '</div>'
            ));
        }
    }

    $footer_sidebars = sh_set(get_option('wp_dastak' . '_theme_options'), 'footer_dynamic_sidebar');

    foreach (array_filter((array) sh_set($footer_sidebars, 'footer_dynamic_sidebar')) as $footer_sidebar) {

        if (sh_set($footer_sidebar, 'sidebar_name') != '') {
            register_sidebar(array(
                'name' => sh_set($footer_sidebar, 'sidebar_name'),
                'id' => bistro_slug(strtolower(sh_set($footer_sidebar, 'sidebar_name'))),
                'before_widget' => '<div id="%1$s" class="widget col-md-' . sh_set($footer_sidebar, 'footer_sidebar_grid') . ' %2$s">',
                'after_widget' => '</div>',
                'before_title' => '<h3>',
                'after_title' => '</h3>'
            ));
        }
    }

    update_option('wp_registered_sidebars', $wp_registered_sidebars);
}

add_action('widgets_init', 'sh_widget_init');

add_action('sh_appointment_form', 'sh_app_form', '', 1);

function sh_app_form($type) {
    if ($type != 'appointment')
        return;
    $members = sh_get_posts_array('sh_team', false);
    if ($members) {
        $output = '<div class="col-md-12">
        <select name="member" class="customlist">
        <option value="">--Select Member--</option>';

        foreach ($members as $k => $v) {
            $member = explode('-', $v);
            $output.= '<option value="' . $k . '">' . $member[0] . '</option>';
        }

        $output .='</select></div>';
        echo $output;
    }
}

add_action('sh_job_form', 'sh_job_form', '', 1);

function sh_job_form($type) {
    if ($type != 'job')
        return;

    if (sh_set($_GET, 'ds_job')) {

        $job = get_post_by_slug(sh_set($_GET, 'ds_job'));
        if ($job) {
            $output = '<div class="heading3">
            <h2><strong>' . __('Apply For Job:', 'wp_dastak') . '</strong> ' . $job->post_title . '</h2>
            </div>';
            $output .='<input type="hidden" name="job_title" value="' . $job->post_title . '">';
            $output .='<input type="hidden" name="job_id" value="' . $job->ID . '">';
            echo $output;
        }
    }
}

add_filter('get_header', 'sh_under_construction');

function sh_under_construction() {
    if (!is_admin() && !is_user_logged_in()) {
        $settings = get_option('wp_dastak' . '_theme_options');
        $comming_date = strtotime(sh_set($settings, 'launch_date'));
        if (sh_set($settings, 'under_const_status') && $comming_date != '' && $comming_date > strtotime(date('y-m-d'))) {
            get_template_part('content', 'coming_soon');
            exit;
        }
    }
}

add_filter('woocommerce_add_to_cart_fragments', 'sh_woo_add_to_cart_ajax');

function sh_woo_add_to_cart_ajax($fragments) {
    global $woocommerce;

    ob_start();

    echo '<div class="cart-section">';
    include('libs/cart_items.php');

    echo '</div>';
    $fragments['div.cart-section'] = ob_get_clean();

    return $fragments;
}

/**
 * Filters the page title appropriately depending on the current page
 *
 * This function is attached to the 'wp_title' fiilter hook.
 *
 * @uses	get_bloginfo()
 * @uses	is_home()
 * @uses	is_front_page()
 */
function sh_filter_wp_title($title) {
    global $page, $paged;

    if (is_feed())
        return $title;
    $site_description = get_bloginfo('description');
    $filtered_title = '';
    if (!empty($site_description)) {
        $filtered_title .= (is_home() || is_front_page()) ? get_bloginfo('name') . ' | ' . $site_description : $title . ' | ' . get_bloginfo('name');
    } else {
        $filtered_title .= ( is_home() || is_front_page() ) ? get_bloginfo('name') : $title;
    }


    $filtered_title .= ( 2 <= $paged || 2 <= $page ) ? ' | ' . sprintf(__('Page %s', 'wp_dastak'), max($paged, $page)) : ' ';

    return $filtered_title;
}

add_filter('wp_title', 'sh_filter_wp_title');

function sh_excerpt_limit($length) {
    return 85;
}

add_filter('excerpt_length', 'sh_excerpt_limit');

add_action('wp_ajax_sh_plugin_update', 'sh_plugin_update');
add_action('wp_ajax_nopriv_sh_plugin_update', 'sh_plugin_update');

function sh_plugin_update() {
    if (isset($_POST['action']) && $_POST['action'] == 'sh_plugin_update') {
        $plugin = sh_set($_POST, 'plugin');
        $slug = sh_set($_POST, 'slug');
        $version = sh_set($_POST, 'version');
        require_once(SH_ROOT . 'includes/modules/update/plugin_notifier.php');
        $object = new SH_Plugin_notifier();
        $response = $object->sh_update_current_plugin($plugin, $slug, $version);
        if ($response == 'ok') {
            echo 'ok';
        } else {
            echo $response;
        }
        exit;
    }
}

add_action('wp_ajax_theme-install-demo-data', 'sh_demo_install');
add_action('wp_ajax_nopriv_theme-install-demo-data', 'sh_demo_install');

function sh_demo_install() {

    if (isset($_POST['action']) && $_POST['action'] == 'theme-install-demo-data') {
        if (sh_set($_POST, 'data') != 'undefined') {
            $demo = sh_set($_POST, 'data');
        } else {
            $demo = 'single';
        }


        if (file_exists(SH_ROOT . "includes/library/backup/" . $demo . "/data.xml")) {
            define('WP_LOAD_IMPORTERS', true);
            if (!class_exists('WP_Import')) {
                include ( SH_ROOT . 'includes/library/wordpress-importer/wordpress-importer.php');
            }

            $content_xml = SH_ROOT . "includes/library/backup/" . $demo . "/data.xml";
            if (!is_file($content_xml)) {
                printr('wrong file');
            } else {
                $GLOBALS['wp_import'] = new WP_Import();
                $GLOBALS['wp_import']->fetch_attachments = true;
                $GLOBALS['wp_import']->import($content_xml);

                _load_class('import_export', 'helpers');
                $GLOBALS['_sh_base']->import_export->import();
            }
        }
        die();
    }
}

add_action('admin_enqueue_scripts', 'sh_admin_scripts_styles');

function sh_admin_scripts_styles(){
    wp_enqueue_style('admin-custom-style', get_template_directory_uri().'/css/admin-custom-style.css', array(), '2.4.2', 'all');
}

add_action('admin_head', 'sh_admin_custom_vars');

function sh_admin_custom_vars()
{
    if( function_exists( 'layerslider' )) $layer_slider_plugin = 'true';
    else $layer_slider_plugin = 'false';
    if(function_exists('vc_map')) $composer_plugin = 'true';
    else $composer_plugin = 'false';
    echo '<script type="text/javascript">var layer_slider_plugin='.$layer_slider_plugin.'; var composer_plugin='.$composer_plugin.';</script>';
}

add_action( 'vc_before_init', 'dastak_vcset_astheme' );

 /**
  * [dastak_vcset_astheme description]
  *
  * @return void [description]
  */
 function dastak_vcset_astheme() {
   vc_set_as_theme();
}

function sh_page_template( $tpl ) {
    $page = get_pages( array( 'meta_key' => '_wp_page_template', 'meta_value' => $tpl ) );
    if ( $page )
        return current( (array) $page );
    else
        return false;
}
require_once( get_template_directory() . '/envato_setup/envato_setup.php' );
add_filter('sh_theme_setup_wizard_username', 'sh_set_theme_setup_wizard_username', 10);
if( ! function_exists('sh_set_theme_setup_wizard_username') ){
    function sh_set_theme_setup_wizard_username($username){
        return 'dtbaker';
    }
}

add_filter('sh_theme_setup_wizard_oauth_script', 'sh_set_theme_setup_wizard_oauth_script', 10);
if( ! function_exists('sh_set_theme_setup_wizard_oauth_script') ){
    function sh_set_theme_setup_wizard_oauth_script($oauth_url){
        return 'http://api.webinane.com/envato/api/server-script.php';
    }
}
add_action( 'init', 'remove_redirect' );
function remove_redirect() {
    remove_action( 'admin_init', 'vc_page_welcome_redirect' );
}

function dastak_get_mc_lists( $assos = true ) {

	if ( ! function_exists( 'mc4wp' ) ) {

		return array();
	}
	if ( ! class_exists( 'MC4WP_Mailchimp' ) ) {

		require_once MC4WP_PLUGIN_DIR . 'includes/class-mailchimp.php';

	}
	$mc4 = new MC4WP_Mailchimp();
	$lists = [];
	if( method_exists($mc4, 'get_lists')) {		
		$lists = $mc4->get_lists();

		if ( $assos ) {

			$return = array();

			foreach( $lists as $list ) {

				$return[$list->id] = $list->name;

			}

			return $return;

		}
	}
	return $lists;

}

function dastak_mailchimp_process( $list,$email ) {

	$mailchimp = new MC4WP_Mailchimp();
	$res = $mailchimp->list_subscribe( $list, $email );

	if ( ! $res ) {

		if ( $mailchimp->error_message instanceof MC4WP_API_Exception ) {

			$res = $mailchimp->error_message->__toString();

		} else {

			$res = $mailchimp->error_message;

		}

	}

	return $res;

}