<?php



class SH_Shortcodes {



    protected $keys;

    protected $toggle_count = 0;



    function __construct() {

        $GLOBALS['sh_toggle_count'] = 0;

        add_action('init', array($this, 'add'));

    }



    function add() {



        $options = array('services_accordion', 'services_2', 'services_3', 'services_4', 'services_5', 'services_6', 'services_list', 'services_carousel', 'about_us', 'about_carousel', 'about_slide', 'our_work_carousel', 'our_work_carousel2', 'portfolio_listing', 'portfolio', 'portfolios_masonary', 'portfolio_2', 'portfolio_3', 'related_items', 'team', 'team2', 'team3', 'team4', 'team_members_carousel', 'team_member1', 'team_member2', 'team_members_carousel,', 'video_box', 'promotional_video', 'conten_box', 'conten_box2', 'conten_box3', 'conten_box4', 'headings', 'twitter_carousel', 'twitter_carousel_two', 'flickr_feeds', 'skills', 'testimonials_listing', 'testimonial_carousel', 'testimonial_carousel2', 'testimonial_carousel3', 'clients', 'our_blog', 'blog_carousel', 'our_blog_two', 'blog_carousel_two', 'our_blog_three', 'post_carousel', 'events', 'events2', 'events_carousel', 'get_in_touch', 'newsletter_form', 'newsletter_form2', 'posibilities', 'percentage_block', 'contact_form', 'contact_form2', 'slider_form', 'appointment_form', 'jo_application_form', 'get_quote_form', 'single_project', 'single_portfolio', 'jobs', 'jobs3', 'job_application_form', 'single_post', 'our_project', 'projects_listing', 'our_offices', 'our_branches', 'our_branches2', 'ceo_box', 'ceo_box2', 'history', 'clients_case_studies1', 'case_studies_accordion', 'news', 'features_banner1', 'banner_slide', 'features_banner2', 'banner_feature', 'features_banner3', 'banner_feature3', 'gallery', 'contact_box', 'social_profile', 'profile_icon', 'dastak_forms', 'post_categories_list', 'fun_facts', 'fact', 'popular_items', 'recent_items', 'recent_items2', 'marketplace', 'ptable', 'ptable_features', 'fancy_ptable', 'fancy_ptable_features', 'heading', 'black_box_img', 'black_box', 'sitemap', 'faqs', 'blockquote', 'awesome_icon', 'button', 'login_form', 'register_form', 'download_banner', 'product_banner', 'awards_listing', 'services_contents', 'content_box_parallax', 'contents_list', 'recent_answers', 'products', 'product_add', 'deals_carousel', 'royalslider', 'parallax_images_carousel', 'parallax_slide', 'fancy_parallax', 'mockup', 'contact_info', 'contact_info_item', 'services_with_image_icon'

        );



        $this->keys = $options; //array_keys( $options );



        foreach ($this->keys as $k) {

            if (method_exists($this, $k))

                add_shortcode('sh_' . $k, array($this, $k));

        }

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_accordion($atts, $contents = null) {

        extract(shortcode_atts(array(

            'style' => '',

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 7;



        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_list($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

       $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 9;



        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'background_image' => '',

            'parallax' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cols' => '',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_4($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'parallax' => '',

            'background_image' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 4;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_5($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

            'image' => '',

            'sort' => 'date',

            'cat' => '',

            'background_image' => '',

            'parallax' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 5;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_6($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 6,

            'sort' => 'date',

            'cols' => 4,

            'cat' => '',

                        ), $atts));

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort);

   

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 6;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 6,

            'sort' => 'date',

            'order' => 'ASC',

            'cat' => '',

            'bg' => '',

            'parallax' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 8;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows services with font awesome icons

     * with a little descriptions in grid view.

     */

    function services_with_image_icon($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 6,

            'sort' => 'date',

            'order' => 'ASC',

            'cat' => '',

            'cols' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $services = 10;

        include( get_template_directory() . '/includes/modules/shortcodes/service_icon.php');



        wp_reset_query();

        return $output;

    }



    function about_us($atts, $contents = null) {

        extract(shortcode_atts(array

            (

            'title' => 'We Are',

            'areas' => '',

            'des' => '',

            'about_image' => ''

                        ), $atts)

        );

        $output = '';

        ob_start();



        $areas = explode(',', $areas);

        ?>



        <div class="we-are-Slide">

            <div id="we-are-rotate">

                <Span><?php echo $title; ?></span>

                <div class="roles">

        <?php foreach ($areas as $area): ?>

                        <div>

            <?php echo $area; ?>

                        </div>

        <?php endforeach; ?>

                </div>

            </div>



            <p><?php echo $des; ?></p>

            <img src="<?php echo wp_get_attachment_url($about_image); ?>" alt="" />

        </div>



                    <?php

                    $output .= ob_get_contents();

                    ob_clean();

                    return $output;

                }



                function about_carousel($atts, $contents = null) {

                    extract(shortcode_atts(array

                        (

                        'title' => 'About Carousel',

                                    ), $atts)

                    );

                    $output = '';

                    ob_start();





                    //$output .= ($title) ? '<div class="heading1">'.sh_get_title2($title).'</div>' : '';

                    $output .='<div id="show-product-slide">' . do_shortcode($contents) . ' </div>';

                    $output .='<script type="text/javascript">

				jQuery(document).ready(function($) {

				

					$("#show-product-slide").owlCarousel({

						autoPlay :true,

						stopOnHover : true,

						goToFirstSpeed : 2000,

						slideSpeed:1500,

						singleItem : true,

						autoHeight : true,

						transitionStyle:"backSlide",

						navigation:true,

						pagination: false

					});		

				

				});

			</script>';





                    return $output;

                }



                function about_slide($atts, $contents = null) {

                    extract(shortcode_atts(array

                        (

                        'title' => '',

                        'des' => '',

                        'about_image' => '',

                        'label' => '',

                        'url' => ''

                                    ), $atts)

                    );

                    $output = '';

                    ob_start();

                    ?>



        <div class="show-product">

            <div class="show-products-lcds">

                <span><img src="<?php echo wp_get_attachment_url($about_image); ?>" alt="" /></span>

            </div>

        <?php echo ($title) ? '<h2>' . $title . '</h2>' : ''; ?>

            <p><?php echo $des; ?></p>

            <a target="_blank" href="<?php echo esc_attr($url); ?>" title="<?php echo esc_attr($title); ?>"><?php echo $label; ?></a>

        </div>



        <?php

        $output .= ob_get_contents();

        ob_clean();

        return $output;

    }



    function download_banner($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => 'Dastak is a Creative Multipurpose HTML Theme, Check its Features in action',

            'label' => 'Download',

            'url' => '#',

            'icon' => '',

                        ), $atts));



        $output = '';



        $output .='<div class="purchase-bar fadein">';

        $output .= ($icon) ? '<i class="fa ' . $icon . '"></i>' : '';

        $output .= ($title) ? '<p>' . $title . '</p>' : '';



        $output .= '<a href="' . $url . '" title="' . $label . '">' . $label . '</a>';

        $output .= '</div>';



        return $output;

    }



    function conten_box($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'slides' => '',

            'url' => '#',

            'label' => '',

                        ), $atts));



        $output = '';

        $style = 'content_box';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function conten_box2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'url' => '#',

            'label' => '',

            'image' => '',

            'parallax' => ''

                        ), $atts));



        $output = '';

        $style = 'content_box_two';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function conten_box3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'description' => '',

            'image' => '',

            'url' => '#',

            'label' => '',

                        ), $atts));



        $output = '';

        $style = 'content_box_three';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function conten_box4($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'image' => '',

            'url' => '#',

            'label' => '',

                        ), $atts));



        $output = '';

        $style = 'content_box_four';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function content_box_parallax($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title1' => '',

            'title2' => '',

            'icon1' => '',

            'icon2' => '',

            'description' => '',

            'url' => '#',

            'label' => '',

            'bg' => '',

            'parallax' => ''

                        ), $atts));



        $output = '';

        $style = 'content_box_parallax';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function contents_list($atts, $contents = null) {

        extract(shortcode_atts(array(

                        ), $atts));



        $output = '';

        $style = 'contents_list';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function video_box($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'video' => '',

            'url' => '#',

            'label' => '',

            'background_image' => '',

            'parallax' => ''

                        ), $atts));



        $output = '';

        $style = 'video_box';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function promotional_video($atts, $contents = null) {

        extract(shortcode_atts(array(

            'sub_title' => '',

            'description' => '',

            'video' => '',

            'location' => '',

            'date' => '',

                        ), $atts));



        $output = '';

        $style = 'promotional_video';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function contact_box($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'phone' => '',

            'background_image' => '',

            'image' => '',

            'url1' => '#',

            'label1' => '',

            'url2' => '#',

            'label2' => '',

                        ), $atts));



        $output = '';

        $style = 'contact_box';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function our_work_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 10,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_project', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'project_category', 'field' => 'id', 'terms' => $cat));

        query_posts($args);

        $output = '';



        $work = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/our_work.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function our_work_carousel2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 10,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_project', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'project_category', 'field' => 'id', 'terms' => (int) $cat));

        $Count_posts = count(query_posts($args));

        $output = '';



        $work = 2;



        include( get_template_directory() . '/includes/modules/shortcodes/our_work.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the testimonails

     */

    function clients($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 6,

            'sort' => 'date',

            'cols' => 2,

            'cat' => '',

            'image' => '',

            'parallax' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_partner', 'showposts' => $num, 'orderby' => $sort);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'partner_category', 'field' => 'id', 'terms' => (int) $cat));

        $clients = 1;

        query_posts($args);

        include( get_template_directory() . '/includes/modules/shortcodes/partners.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function portfolio_listing($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'cols' => '',

            'order' => 'DESC',

            'sort' => 'date',

            'cat' => '',

            'tabs' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_portfolio', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        $cat = explode(',', $cat);



        if (sh_set($cat, 0) != 0)

            $args['tax_query'] = array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => $cat));

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/portfolio4.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function portfolio($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 10,

            'sort' => 'date',

            'order' => 'DESC',

            /* 'style' => '1', */

            'cat' => ''

                        ), $atts));

        $cat = explode(',', $cat);

        $args = array('post_type' => 'sh_portfolio', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);



        if (sh_set($cat, 0) != 0)

            $args['tax_query'] = array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => $cat));

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/portfolio.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function portfolios_masonary($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 10,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => '',

            'tabs' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_portfolio', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        $cat = explode(',', $cat);



        if (sh_set($cat, 0) != 0)

            $args['tax_query'] = array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => $cat));

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/portfolios_masonary.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function portfolio_2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 10,

            'orderby' => 'date',

            'order' => 'DESC',

            'col' => '',

            'cat' => '',

            'style' => '1',

            'tabs' => '',

                        ), $atts));



        wp_enqueue_script('portfolio_filter');



        $args = array('post_type' => 'sh_portfolio', 'showposts' => $num, 'orderby' => $orderby, 'order' => $order);

        $cat = explode(',', $cat);



        if (sh_set($cat, 0) != 0)

            $args['tax_query'] = array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => $cat));



        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/portfolio2.php');



        wp_reset_query();



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function portfolio_3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'orderby' => 'date',

            'order' => 'DESC',

            'cat' => '',

                        ), $atts));



        wp_enqueue_script('portfolio_filter');



        $args = array('post_type' => 'sh_project', 'showposts' => $num, 'orderby' => $orderby, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'project_category', 'field' => 'id', 'terms' => (int) $cat));



        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/portfolio3.php');



        wp_reset_query();



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function our_project($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_project', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'project_category', 'field' => 'id', 'terms' => (int) $cat));





        query_posts($args);



        $project = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/project.php');



        wp_reset_query();



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function projects_listing($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'cols' => '4',

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_project', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'project_category', 'field' => 'id', 'terms' => (int) $cat));





        query_posts($args);



        $project = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/project.php');



        wp_reset_query();



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows portfolio with filteration on top 

     * to allow user to filter porfolio by category

     */

    function related_items($atts, $contents = null) {

        global $post, $wp_query;

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 10,

            'cat' => true,

                        ), $atts));



        $args = array('post_type' => 'sh_portfolio', 'showposts' => $num, 'post__not_in' => array($post->ID));

        if ($cat) {

            $terms = wp_get_post_terms($post->ID, 'portfolio_category', array('fields' => 'ids'));

            $args['tax_query'] = array(array('taxonomy' => 'portfolio_category', 'field' => 'id', 'terms' => (int) $terms));

        }



        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/related.php');



        wp_reset_query();



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cols' => '3',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_team', 'showposts' => $num, 'orderby' => $sort);

        if($cat && is_numeric($cat))

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'id', 'terms' => (int) $cat));

        elseif ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'slug', 'terms' => $cat));

        query_posts($args);

        $team = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_team', 'showposts' => $num, 'orderby' => $sort);

        if($cat && is_numeric($cat))

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'id', 'terms' => (int) $cat));

        elseif ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'slug', 'terms' => $cat));

        query_posts($args);

        $team = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_team', 'showposts' => $num, 'orderby' => $sort);

        if($cat && is_numeric($cat))

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'id', 'terms' => (int) $cat));

        elseif ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'slug', 'terms' => $cat));

        query_posts($args);

        $team = 5;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team4($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'order' => 'DESC',

            'image' => '',

            'parallax' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_team', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if($cat && is_numeric($cat))

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'id', 'terms' => (int) $cat));

        elseif ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'slug', 'terms' => $cat));

        query_posts($args);

        $team = 7;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team_member1($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Our Creative Team', 'wp_dastak'),

            'member' => '',

                        ), $atts));



        $team = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team_member2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'member' => '',

                        ), $atts));



        $team = 4;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function team_members_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => '',

            'sort' => '',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_team', 'showposts' => $num, 'orderby' => $sort);

        if($cat && is_numeric($cat))

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'id', 'terms' => (int) $cat));

        elseif ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'team_category', 'field' => 'slug', 'terms' => $cat));

        query_posts($args);

        $team = 6;

        include( get_template_directory() . '/includes/modules/shortcodes/team.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function twitter_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'id' => 'wordpress',

            'num' => 3,

            'label' => '',

            'url' => '',

            'image' => '',

            'parallax' => ''

                        ), $atts));



        $style = 'twitter_carousel';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function twitter_carousel_two($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'id' => 'wordpress',

            'num' => 3,

            'label' => '',

            'image' => ''

                        ), $atts));



        $style = 'twitter_carousel_two';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows team members from different departments

     * their skills and social icons.

     */

    function flickr_feeds($atts, $contents = null) {

        extract(shortcode_atts(array(

            'id' => '',

            'num' => 3,

                        ), $atts));



        $style = 'flickr_feeds';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        wp_reset_query();

        return $output;

    }



    function skills($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('HTML5 & CSS3', 'wp_dastak'),

            'percent' => 80,

                        ), $atts));



        return

                '<div class="col-lg-3 col-md-3 col-sm-6 col-xs-12">

				<span class="chart" data-percent="' . $percent . '">

					<span class="percent"></span>

				</span>

				<h4 class="title">' . $title . '</h4>

			</div>';

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the testimonails

     */

    function testimonials_listing($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => '',

                        ), $atts));



        $args = array('post_type' => 'sh_testimonial', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        $cat_exist = get_term_by( 'id', $cat, 'testimonial_category');

  



        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'testimonial_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $testimonial = 4;

        include( get_template_directory() . '/includes/modules/shortcodes/testimonial.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the testimonails

     */

    function testimonial_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'sort' => 'date',

            'cat' => '',

            'image' => '',

            'parallax' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_testimonial', 'showposts' => $num, 'orderby' => $sort);

        

        $cat_exist = get_term_by( 'id', $cat, 'testimonial_category');

  



        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'testimonial_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        



        query_posts($args);

        $testimonial = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/testimonial.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the testimonails

     */

    function testimonial_carousel2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 3,

            'image' => '',

            'sort' => 'date',

            'cat' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_testimonial', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'testimonial_category');

  



        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'testimonial_category', 'field' => 'id', 'terms' => (int) $cat));

        }



        query_posts($args);

        $testimonial = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/testimonial.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the testimonails

     */

    function testimonial_carousel3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 3,

            'image' => '',

            'sort' => 'date',

            'cat' => ''

                        ), $atts));



        $args = array('post_type' => 'sh_testimonial', 'showposts' => $num, 'orderby' => $sort);

        $cat_exist = get_term_by( 'id', $cat, 'testimonial_category');

  



        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'testimonial_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);

        $testimonial = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/testimonial.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows events 

     * with a little descriptions in grid view.

     */

    function events($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));



        if ($sort == 'upcoming') {

            $args = array('post_type' => 'sh_event', 'showposts' => $num, 'order' => 'ASC');

        } else {

            $args = array('post_type' => 'sh_event', 'showposts' => $num, 'orderby' => $sort);

        }

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'event_category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);

        $events = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/events.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows events 

     * with a little descriptions in grid view.

     */

    function events2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));



        if ($sort == 'upcoming') {

            $args = array('post_type' => 'sh_event', 'showposts' => $num, 'order' => 'ASC');

        } else {

            $args = array('post_type' => 'sh_event', 'showposts' => $num, 'orderby' => $sort);

        }

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'event_category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);

        $events = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/events.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows events 

     * with a little descriptions in grid view.

     */

    function events_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cols' => '4',

            'cat' => '',

            'carousel' => '',

                        ), $atts));



        if ($sort == 'upcoming') {

            $args = array('post_type' => 'sh_event', 'showposts' => $num, 'meta_key' => 'sh_event_start_time', 'meta_query' => array(array('key' => 'sh_event_start_time', 'value' => date('Y-m-d h:i:s'), 'type' => 'datetime', 'compare' => '>=')), 'orderby' => 'meta_value', 'order' => 'ASC');

        } else {

            $args = array('post_type' => 'sh_event', 'showposts' => $num, 'orderby' => $sort);

        }

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'event_category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);

        $events = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/events.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function contact_form($atts, $contents = null) {

        extract(shortcode_atts(array(

            'content' => '',

            'email' => '',

            'phone' => '',

            'address' => '',

            'map' => '',

            'form' => '',

                        ), $atts));



        $contact = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function get_in_touch($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Get In Touch', 'wp_dastak'),

            'to_email' => '',

            'mail_subject'  => '',

                        ), $atts));



        $contact = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function dastak_forms($atts, $contents = null) {

        extract(shortcode_atts(array(

            'form' => '',

        ), $atts));



        $contact = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function appointment_form($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'form' => '',

                        ), $atts));



        $contact = 4;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function job_application_form($atts, $contents = null) {

        extract(shortcode_atts(array(

            'form' => '',

                        ), $atts));



        $contact = 8;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function get_quote_form($atts, $contents = null) {

        extract(shortcode_atts(array(

            'form' => '',

                        ), $atts));



        $contact = 5;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function contact_form2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'content' => '',

            'form' => '',

            'image' => '',

                        ), $atts));



        $contact = 6;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows the contact form with map and detail

     */

    function slider_form($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'content' => '',

            'form' => '',

            'image' => '',

            'slider' => '',

                        ), $atts));



        $contact = 7;

        include( get_template_directory() . '/includes/modules/shortcodes/contact_form.php');



        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows social profile icons

     */

    function social_profile($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Social Media Profile', 'wp_dastak'),

                        ), $atts));



        $output .= do_shortcode($contents);



        return $output;

    }



    function royalslider($atts, $contents = null) {

        extract(shortcode_atts(array(

            'slider' => '',

                        ), $atts));



        $output = (function_exists('get_new_royalslider')) ? get_new_royalslider($slider) : '';

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows social profile icons

     */

    function profile_icon($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'link' => '',

            'icon' => ''

                        ), $atts));



        $output = '<div class="col-lg-2 col-md-2 col-sm-2">

						<div class="servicebox text-center">

							<div class="service-icon">

								<div class="dm-icon-effect-1" data-effect="slide-left">

									<a href="' . esc_url($link) . '" class=""> <i class="dm-icon fa fa-' . $icon . ' fa-3x"></i> </a>

								</div>

								<div class="servicetitle">

								<h4>' . $title . '</h4>

								</div>

							</div><!-- service-icon -->

						</div><!-- servicebox -->

					</div><!-- large-3 -->';

        $output .= do_shortcode($contents);



        return $output;

    }



    function posibilities($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'description' => '',

            'image' => '',

            'parallax' => ''

                        ), $atts));



        wp_enqueue_script('jquery-circliful');

        $output = '<div class="' . $parallax . ' parallax">';

        $background_image = ($image) ? 'style="background-image:url(' . wp_get_attachment_url($image) . ');"' : '';

        $output .= ($background_image) ? '<div class="fixed-img sec-bg16" ' . $background_image . '></div>' : '';

        $output .='<div class="container">

					<div id="our-Skill-sec">';

        $output .= ($title) ? '<h3>' . $title . '</h3>' : '';

        $output .= '<p>' . $description . '</p>';

        $output .= '<ul>' . do_shortcode($contents) . '</ul>';

        $output .= '</div></div></div>';



        $output .='<script>

					jQuery( document ).ready(function($) {

							$(".myStat").circliful();

					});

					</script>';





        return $output;

    }



    function percentage_block($atts, $contents = null) {

        extract(shortcode_atts(array(

            'value' => '',

            'title' => ''

                        ), $atts));

        $settings = get_option('wp_dastak' . '_theme_options');



        $output = '<li>

						<div class="myStat" data-dimension="180" data-text="' . $value . '%" data-width="8" data-info="' . $title . '" data-fontsize="30" data-percent="' . $value . '" data-fgcolor="' . sh_set($settings, 'custom_color_scheme') . '" data-bgcolor="#fff"></div>

					</li>';





        return $output;

    }



    function single_project($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'project' => '',

                        ), $atts));



        $single_post = get_post($project);



        $output = '';



        $output .= '<div class="tab-project">

						<div class="row">';



        $images = get_children(array('post_parent' => $project, 'post_type' => 'attachment', 'post_mime_type' => 'image', 'numberposts' => 3));

        foreach ($images as $image):



            $output .= '<div class="col-md-4">' . wp_get_attachment_image($image->ID, '284x216') . '</div>';



        endforeach;



        $output .= '</div>';

        $output .= '<p>' . character_limiter($single_post->post_content, 300, '') . '</p>';

        $output .= '</div>';



        return $output;

    }



    function single_portfolio($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'portfolio' => '',

                        ), $atts));



        $single_post = get_post($portfolio); //printr($single_post);



        $output = '';



        $output .= '<div class="tab-work">';



        $output .= '<span>' . get_the_post_thumbnail($single_post->ID, '273x197') . '</span>';



        $output .= '<p>' . character_limiter($single_post->post_content, 400) . '</p>';

        $output .= '<a href="' . get_permalink($single_post->ID) . '" title="' . get_the_title() . '">' . __('Read More', 'wp_dastak') . '</a>';

        $output .= '</div>';



        return $output;

    }



    function single_post($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'post' => '',

                        ), $atts));



        $single_post = get_post($post); //printr($single_post);



        $output = '';



        $output .= '<div class="tab-article">

						<div class="row">';

        $output .= '<div class="col-md-8">

						<p>' . character_limiter($single_post->post_content, 400) . '</p>

					</div>';



        $output .= '<div class="col-md-4">' . get_the_post_thumbnail($single_post->ID, '273x197') . '</div>';

        $output .= '</div>';

        $output .= '</div>';



        return $output;

    }



    function fun_facts($atts, $contents = null) {

        extract(shortcode_atts(array(

            'parallax' => '',

            'image' => '',

                        ), $atts));

        wp_enqueue_script(array('jquery-counterup', 'waypoints'));

        $background_image = ($image) ? 'style="background-image:url(' . wp_get_attachment_url($image, 'full') . ')"' : '';



        $output = '<div class="' . $parallax . '">

						<div class="fixed-img sec-bg5" ' . $background_image . '></div>

						<div class="container">

							<div class="row">' . do_shortcode($contents) . '</div>

						</div>

				   </div>';



        $output .='<script>

						jQuery(document).ready(function($) {

							$(".count").counterUp({

								delay: 10,

								time: 1000

							});

						});

					</script>';



        return $output;

    }



    function fact($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'value' => '',

            'icon' => ''

                        ), $atts));



        $output = '<div class="col-md-3">

						<div class="counter">

							<i class="fa ' . $icon . '"></i>

							<h4>' . $title . '</h4>

							<h5 class="count">' . $value . '</h5>

						</div>

					</div>';



        return $output;

    }



    function ptable($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Standard', 'wp_dastak'),

            'symbol' => '',

            'period' => '',

            'price' => '',

            'btn' => __('Order Now', 'wp_dastak'),

            'btn_link' => '',

                        ), $atts));



        $view = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/pricing_table.php');



        return $output;

    }



    function ptable_features($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Standard', 'wp_dastak'),

                        ), $atts));



        $view = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/pricing_table.php');



        return $output;

    }



    function fancy_ptable($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'symbol' => '',

            'period' => '',

            'price' => '',

            'btn' => '',

            'btn_link' => '',

            'image' => ''

                        ), $atts));



        $view = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/pricing_table.php');



        return $output;

    }



    function fancy_ptable_features($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

                        ), $atts));



        $view = 4;

        include( get_template_directory() . '/includes/modules/shortcodes/pricing_table.php');



        return $output;

    }



    function black_box_img($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Standard', 'wp_dastak'),

            'btn_link' => '',

            'btn_label' => '',

            'btn1_label' => '',

            'btn1_link' => '',

            'img' => ''

                        ), $atts));



        $style = 'black_box_img';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function black_box($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Standard', 'wp_dastak'),

            'btn_link' => '',

            'btn_label' => '',

            'btn1_label' => '',

            'btn1_link' => '',

            'desc' => ''

                        ), $atts));



        $style = 'black_box';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function our_offices($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

                        ), $atts));



        $office = 'our_offices';

        include( get_template_directory() . '/includes/modules/shortcodes/office.php');



        return $output;

    }



    function our_branches($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

                        ), $atts));



        $office = 'our_branches';

        include( get_template_directory() . '/includes/modules/shortcodes/office.php');



        return $output;

    }



    function our_branches2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

                        ), $atts));



        $office = 'our_branches2';

        include( get_template_directory() . '/includes/modules/shortcodes/office.php');



        return $output;

    }



    function ceo_box($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'designation' => '',

            'description' => '',

                        ), $atts));



        $style = 'ceo_box';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function ceo_box2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'name' => '',

            'description' => '',

            'image' => '',

                        ), $atts));



        $style = 'ceo_box2';

        include( get_template_directory() . '/includes/modules/shortcodes/general.php');



        return $output;

    }



    function history($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

            'sort' => 'title',

            'order' => 'ASC'

                        ), $atts));



        $args = array('post_type' => 'sh_history', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/history.php');

        wp_reset_query();

        return $output;

    }



    function clients_case_studies1($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date'

                        ), $atts));





        $args = array('post_type' => 'sh_case_studies', 'showposts' => $num, 'orderby' => $sort);

        query_posts($args);



        $case = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/case_studies.php');

        wp_reset_query();

        return $output;

    }



    function case_studies_accordion($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date'

                        ), $atts));





        $args = array('post_type' => 'sh_case_studies', 'showposts' => $num, 'orderby' => $sort);

        query_posts($args);



        $case = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/case_studies.php');

        wp_reset_query();

        return $output;

    }



    function news($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'cat' => '',

            'sort' => 'date'

                        ), $atts));





        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort);

        

        $cat_exist = get_term_by( 'id', $cat, 'category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));

        }

        

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/news.php');

        wp_reset_query();

        return $output;

    }



    function features_banner1($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'image' => '',

            'parallax' => '',

            'background_image' => ''

                        ), $atts));



        $features = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/features.php');



        return $output;

    }



    function banner_slide($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title1' => '',

            'title2' => '',

            'title3' => '',

            'icon1' => '',

            'icon2' => '',

            'icon3' => '',

                        ), $atts));



        $features = 'child_1';

        include( get_template_directory() . '/includes/modules/shortcodes/features.php');



        return $output;

    }



    function features_banner2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'description' => '',

            'image' => '',

            'parallax' => '',

            'background_image' => '',

            'width' => '',

            'top' => '',

            'left' => '',

                        ), $atts));



        $features = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/features.php');



        return $output;

    }



    function banner_feature($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'icon' => '',

                        ), $atts));



        $features = 'child_2';

        include( get_template_directory() . '/includes/modules/shortcodes/features.php');



        return $output;

    }



    function features_banner3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'description' => '',

            'image' => '',

                        ), $atts));



        $features = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/features.php');



        return $output;

    }



    function banner_feature3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'description' => '',

            'icon' => '',

                        ), $atts));



        $features = 'child_3';

        include( get_template_directory() . '/includes/modules/shortcodes/features.php');



        return $output;

    }



    function gallery($atts, $contents = null) {

        extract(shortcode_atts(array(

            'per_page' => '6',

            'cols' => '',

            'sort' => 'date',

            'cat' => '',

            'masonary' => false,

                        ), $atts));

        global $wp_query;

        $paged = ( get_query_var('paged') ) ? get_query_var('paged') : 1;

        $args = array('post_type' => 'sh_gallery', 'showposts' => $per_page, 'orderby' => $sort, 'paged' => $paged);



        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'gallery_category', 'field' => 'id', 'terms' => (int) $cat));



        $wp_query = new WP_Query($args);



        include( get_template_directory() . '/includes/modules/shortcodes/gallery.php');



        wp_reset_query();



        return $output;

    }



    function faqs($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Faqs', 'wp_dastak'),

            'num' => 10,

            'orderby' => 'date',

            'cat' => '',

            'order' => 'DESC',

                        ), $atts));



        $args = array(

            'posts_per_page' => $num,

            'post_status' => 'publish',

            'post_type' => 'sh_faq',

            'orderby' => $orderby,

            'order' => $order

        );

        /** make a general query of provided query args */

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'faq_category', 'field' => 'slug', 'terms' => $cat));

        //printr($args);

        query_posts($args);



        $view = 1;



        include( get_template_directory() . '/includes/modules/shortcodes/faqs.php');

        wp_reset_query();



        return $output;

    }



    function post_categories_list($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 6,

                        ), $atts));

        $args = array('number' => $num);

        $categories = get_categories();



        $output = '<div class="s-category-widget">';





        if ($categories) {



            $output .='<ul>';

            foreach ($categories as $category) {



                $category_meta = get_option('_sh_category_settings' . $category->term_id);

                $meta = sh_set(sh_set($category_meta, 'sh_post_options'), '0');

                $output .='<li><a href="' . get_category_link($category->term_id) . '" title="' . sprintf(__("View all posts in %s", 'wp_dastak'), $category->name) . '"><i class="fa ' . str_replace('icon-', 'fa-', sh_set($meta, 'icon')) . '"></i>' . $category->name . '<span>(' . $category->count . ')</span></a></li>';

            }

            $output .='</ul>';

        }

        $output .='</div>';



        return $output;

    }



    function blockquote($atts, $contents = null) {

        extract(shortcode_atts(array(

            'from' => '',

            'align' => 'pull-left',

            'class' => '',

            'id' => ''

                        ), $atts));





        $typo = 'blockquote';



        include( get_template_directory() . '/includes/modules/shortcodes/typography.php');



        return $output;

    }



    function newsletter_form($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'id' => '',
            'form_type' => '',
            'newsltr_mc_lists' => '',


            'button_text' => __('Subscribe', 'wp_dastak')

                        ), $atts));



        $output = '';

        $typo = 'newsletter_form';



        include( get_template_directory() . '/includes/modules/shortcodes/typography.php');



        return $output;

    }



    function newsletter_form2($atts, $contents = null) {

        extract(shortcode_atts(array(

            'sub_title' => '',

            'id' => '',
            'form_type' => '',
            'newsltr_mc_lists' => '',

            'button_text' => __('Subscribe', 'wp_dastak')

                        ), $atts));





        $typo = 'newsletter_form2';



        include( get_template_directory() . '/includes/modules/shortcodes/typography.php');



        return $output;

    }



    function excerpt($str, $len = 35) {

        return substr(strip_tags($str), 0, $len) . '..';

    }



    function our_blog($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'order' => 'DESC'

                        ), $atts));



        $output = '';



        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);



        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));



        $output .='<div class="row"><div class="our-blog4">';



        ob_start();



        query_posts($args);



        while (have_posts()) : the_post();

            ?>

            <?php global $post; ?>



            <div class="col-md-3">

                <div class="our-blog4-box">

                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo get_the_post_thumbnail($post->ID, '284x216'); ?></a>

                    <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title(), 25); ?></a></h3>

                    <p><?php echo character_limiter(get_the_content(), 100); ?></p>

                    <ul class="blog4-metas">

                        <li><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>" title=""><i class="fa fa-user"></i><?php the_author_meta('display_name'); ?></a></li>

                        <li><a href="javascript:void(0);" title=""><i class="fa fa-calendar-o"></i><?php echo get_the_date('j F'); ?></a></li>

                    </ul>

                </div>

            </div><!-- Our Blog Box4 -->







        <?php

        endwhile;

        wp_reset_query();

        $output .=ob_get_contents();

        $output .='</div></div>';

        ob_end_clean();



        return $output;

    }



    function our_blog_two($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'order' => 'DESC'

                        ), $atts));



        $output = '';



        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));



        $output .='<div class="top-margin">

					<div class="row">';



        ob_start();



        query_posts($args);



        while (have_posts()) : the_post();

            ?>

            <?php global $post; ?>



            <div class="col-md-6">



                <div class="our-blog3-box fadein">

                    <span> <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo get_the_post_thumbnail($post->ID, '370x370'); ?></a></span>

                    <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title(), 40); ?></a></h3>

                    <p><?php echo character_limiter(get_the_content(), 120); ?></p>

                    <ul>

                        <li><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>" title=""><i class="fa fa-user"></i><?php the_author_meta('display_name'); ?></a></li>

                        <li><a href="javascript:void(0);" title=""><i class="fa fa-calendar-o"></i><?php echo get_the_date(get_option('date_format')); ?></a></li>

                        <li><?php echo get_the_category_list('</li><li>'); ?></li>

                    </ul>

                </div>

            </div>



        <?php

        endwhile;

        wp_reset_query();

        $output .=ob_get_contents();

        $output .='</div></div>';

        ob_end_clean();



        return $output;

    }



    function our_blog_three($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

            'sort' => 'date',

            'cols' => '4',

            'cat' => '',

            'order' => 'DESC'

                        ), $atts));



        $output = '';



        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));

        $output .='<div class="top-margin">';

        $output .='<div class="row">';



        ob_start();



        query_posts($args);



        while (have_posts()) : the_post();

            ?>

            <?php global $post; ?>



            <div class="col-md-<?php echo esc_attr($cols); ?>">

                <div class="our-blog-box bouncein">

                    <div class="our-blog-link">

            <?php echo get_the_post_thumbnail($post->ID, '370x200'); ?>

                        <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><i class="fa fa-link"></i></a>

                    </div>

                    <h2><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title(), 25, ''); ?></a></h2>

                    <span><i class="fa fa-user"></i><?php _e('Posted by', 'wp_dastak') ?> <strong><?php the_author_meta('display_name'); ?></strong></span>

                    <span><i class="fa fa-tag"></i><?php _e('in', 'wp_dastak') ?> <strong><?php the_tags(', '); ?></strong></span>

                    <p><?php echo character_limiter(get_the_content(), 150); ?></p>

                </div>

            </div>	



        <?php

        endwhile;

        wp_reset_query();

        $output .=ob_get_contents();

        $output .='</div>';

        $output .='</div>';

        ob_end_clean();



        return $output;

    }



    function blog_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'order' => 'DESC',

            'cols' => '3'

                        ), $atts));



        $output = '';



        if ($cols == 2) {

            $cols_num = 'col-md-6';

            $remainder = 2;

        } elseif ($cols == 4) {

            $cols_num = 'col-md-3';

            $remainder = 4;

        } else {

            $cols_num = 'col-md-4';

            $remainder = 3;

        }



        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));



        $output .='<div class="our-blog-slide top-margin"><div class="row">';



        ob_start();



        query_posts($args);

        $i = 1;

        $archive_year  = get_the_time('Y'); 

        $archive_month = get_the_time('m'); 

        $archive_day   = get_the_time('d');



        while (have_posts()) : the_post();''

            ?>



            <?php global $post, $wp_query; ?>

            <div class="<?php echo esc_attr($cols_num); ?>">

                <div class="our-blog4-box">

                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo get_the_post_thumbnail($post->ID, '284x216'); ?></a>

                    <h3><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title(), 50, ''); ?></a></h3>

                    <p><?php echo character_limiter(get_the_content(), 100); ?></p>

                    <ul class="blog4-metas">

                        <li><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>" title=""><i class="fa fa-user"></i><?php the_author_meta('display_name'); ?></a></li>

                        <li><a href="<?php echo get_day_link( $archive_year, $archive_month, $archive_day); ?>" title=""><i class="fa fa-calendar-o"></i><?php echo date(get_option('date_format', get_the_date())); ?></a></li>

                    </ul>

                </div>

            </div><!-- Our Blog Box4 -->

            <?php if ($i % $remainder == 0 && $i == $wp_query->post_count): ?>

            <?php elseif ($i % $remainder == 0): ?>

                </div><div class="row">

            <?php endif; ?>

            <?php $i++; ?>

        <?php

        endwhile;

        wp_reset_query();

        $output .=ob_get_contents();

        $output .='</div></div>';

        $output .='<script type="text/javascript">

							jQuery(document).ready(function($) {

							

								$(".our-blog-slide").owlCarousel({

									autoPlay :true,

									stopOnHover : true,

									goToFirstSpeed : 2000,

									slideSpeed:1500,

									singleItem : true,

									autoHeight : true,

									transitionStyle:"backSlide",

									navigation:true

								});

							});

						</script>';

        ob_end_clean();



        return $output;

    }



    function blog_carousel_two($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'order' => 'DESC',

            'background_image' => ''

                        ), $atts));



        $output = '';



        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));



        $image = ($background_image) ? 'style="background-image:url(' . wp_get_attachment_url($background_image, 'full') . ');"' : '';



        $output .= '<div class="dark">	

						<div class="fixed-img sec-bg4" ' . $image . '></div>

							<div class="latest-project-sec">';



        $output .='<div id="latest-project"><div class="row">';



        ob_start();



        query_posts($args);

        $i = 1;

        while (have_posts()) : the_post();

            ?>

            <?php global $post; ?>

                <div class="col-md-4">

                    <div class="latest-project">

                        <div class="ltst-project-img">

            <?php echo get_the_post_thumbnail($post->ID, '370x272'); ?>

                            <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><i class="fa fa-link"></i></a>

                        </div>

                        <h2><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php echo character_limiter(get_the_title(), 30); ?></a></h2>

                        <p><?php echo character_limiter(get_the_content(), 150); ?></p>

                    </div>

                </div>

            <?php if ($i % 3 == 0): ?>

                </div><div class="row">

            <?php endif; ?>

            <?php $i++; ?>

        <?php

        endwhile;

        wp_reset_query();

        $output .=ob_get_contents();

        $output .='</div></div>';

        $output .='<script type="text/javascript">

							jQuery(document).ready(function($) {

							

								$("#latest-project").owlCarousel({

									autoPlay :true,

									stopOnHover : true,

									goToFirstSpeed : 2000,

									slideSpeed:1500,

									singleItem : true,

									autoHeight : true,

									transitionStyle:"backSlide",

									navigation:false,

									pagination: false

									});	

							});

						</script>';

        $output .= '</div></div>';

        ob_end_clean();



        return $output;

    }



    function awards_listing($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => __('Our Blog', 'wp_dastak'),

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

            'order' => 'DESC'

                        ), $atts));



        $output = '';

        //echo $cat;exit;

        $args = array('post_type' => 'post', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);

        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/awards.php');



        wp_reset_query();



        return $output;

    }



    function services_contents($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'cat' => '',

            'num' => 6,

            'orderby' => 'date',

            'order' => 'DESC',

            'grid' => '6',

            'more' => '',

            'limit' => '80',

            'services_listing' => ''

                        ), $atts));



        $output = '';



        $services = 1;



        $args = array('post_type' => 'sh_service', 'showposts' => $num, 'orderby' => $orderby, 'order' => $order);

        

        $cat_exist = get_term_by( 'id', $cat, 'service_category');

  

        if ($cat_exist) {

            $args['tax_query'] = array(array('taxonomy' => 'service_category', 'field' => 'id', 'terms' => (int) $cat));

        }

        query_posts($args);



        include( get_template_directory() . '/includes/modules/shortcodes/services.php');

        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 1 in html version .. it shows jobs 

     * with a little descriptions in grid view.

     */

    function jobs($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

            'sort' => 'date',

            'cat' => '',

                        ), $atts));





        $args = array('post_type' => 'sh_jobs', 'showposts' => $num, 'orderby' => $sort);



        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'job_category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);

        $jobs = 1;

        include( get_template_directory() . '/includes/modules/shortcodes/jobs.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 13. it shows jobs 

     * with a little descriptions in grid view.

     */

    function jobs3($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'num' => 4,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => '',

                        ), $atts));





        $args = array('post_type' => 'sh_jobs', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);



        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'job_category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);

        $jobs = 3;

        include( get_template_directory() . '/includes/modules/shortcodes/jobs.php');



        wp_reset_query();

        return $output;

    }



    /**

     * This shortcodes is used on homepage 13. it shows jobs 

     * with a little descriptions in grid view.

     */

    function recent_answers($atts, $contents = null) {

        extract(shortcode_atts(array(

            'num' => 4,

            'sort' => 'date',

            'order' => 'DESC',

            'cat' => '',

                        ), $atts));





        $args = array('post_type' => 'sh_faq', 'showposts' => $num, 'orderby' => $sort, 'order' => $order);



        if ($cat)

            $args['tax_query'] = array(array('taxonomy' => 'faq_category', 'field' => 'id', 'terms' => (int) $cat));

        query_posts($args);

        $view = 2;

        include( get_template_directory() . '/includes/modules/shortcodes/faqs.php');



        wp_reset_query();

        return $output;

    }



    function products($atts, $content = null) {

        extract(shortcode_atts(array(

            'number' => 4,

            'orderby' => 'date',

            'order' => 'ASC',

            'col' => 4,

            'cat' => '',

            'style' => 1,

            'carousel' => false,

            'social_icons' => false,

                        ), $atts));

        global $product;

        $query_args = array(

            'orderby' => $orderby,

            'order' => $order,

            'showposts' => $number,

            'post_type' => 'product',

        );



        if ($cat)

            $query_args['tax_query'] = array(array('taxonomy' => 'product_cat', 'field' => 'id', 'terms' => (int) $cat));



        $query = new WP_Query($query_args);



        include( get_template_directory() . '/includes/modules/shortcodes/products.php');

        wp_reset_query();



        return $output;

    }



    function product_add($atts, $content = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'label' => '',

            'url' => '',

            'image' => '',

                        ), $atts));



        $output = '<div class="add-item">';

        $output .= ($image) ? '<span>' . wp_get_attachment_image($image) . '</span>' : '';

        $output .= '<div class="add-detail">';

        $output .= ($sub_title) ? '<h4>' . $sub_title . '</h4>' : '';

        $output .= ($title) ? '<h3>' . $title . '</h3>' : '';

        $output .= ($content) ? '<p>' . $content . '</p>' : '';

        $output .= ($label) ? '<a href="' . $url . '" title="' . $label . '">' . $label . '<i class="fa  fa-arrow-circle-o-right"></i></a>' : '';

        $output .= '</div>';

        $output .='</div>';



        return $output;

    }



    function deals_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'number' => 8,

            'orderby' => 'date',

            'order' => 'ASC',

                        ), $atts));



        $args = array('post_type' => 'sh_deal', 'showposts' => $number, 'orderby' => $orderby, 'order' => $order);



        $query = new WP_Query($args);



        include(get_template_directory() . '/includes/modules/shortcodes/deals.php');



        wp_reset_query();



        return $output;

    }



    function headings($atts, $contents = null) {

        extract(shortcode_atts(array(

            'style' => '1',

            'title' => '',

            'sub_title' => ''

                        ), $atts));





        $typo = 'headings';



        include( get_template_directory() . '/includes/modules/shortcodes/typography.php');



        return $output;

    }



    function parallax_images_carousel($atts, $contents = null) {

        extract(shortcode_atts(array(

            'thumbs' => '',

            'parallax' => '',

            'parallax_image' => '',

                        ), $atts));



        $images = explode(',', $thumbs);

        wp_enqueue_script('dangerous-swip');

        $background_image = ($parallax_image) ? 'style="background-image:url(' . wp_get_attachment_url($parallax_image, 'full') . ')"' : '';

        $classes = ($thumbs) ? 'col-md-9' : 'col-md-12';

        $output = '<div class="' . $parallax . '" >

					<div class="fixed-img sec-bg8" ' . $background_image . '></div>

					<div class="container">

						<div class="fancy-swipe">

							<div class="row">';

        if ($images) {

            $output .='<div class="col-md-3">

											<div class="swiper-container">

												<a class="arrow-left" href="#"><i class="fa fa-arrow-up"></i></a> 

												<a class="arrow-right" href="#"><i class="fa fa-arrow-down"></i></a>

												<ul class="swiper-wrapper nav nav-tabs fancy-tabs">';

            $i = 1;

            foreach ($images as $image) {

                $class = ($i == 1) ? 'active' : '';

                $output .= '<li class="' . $class . ' swiper-slide"><a href="#' . $i . '" data-toggle="tab">' . wp_get_attachment_image($image, '870x347') . '</a></li>';

                $i++;

            }

            $output .= '</ul>

												<div class="pagination"></div>

											</div>

										</div>';

            $output .= '<div class="col-md-9">

												<div class="tab-content">';

            $i = 1;

            foreach ($images as $image) {

                $class = ($i == 1) ? 'in active' : '';

                $output .= '<div id="' . $i . '" class="tab-pane fade ' . $class . '">' . wp_get_attachment_image($image, '870x347') . '</div>';

                $i++;

            }

            $output .= '</div>

											</div>';

        }

        $output .='		</div>

						</div>

					</div>

				</div>';





        return $output;

    }



    function fancy_parallax($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title1' => '',

            'title2' => '',

            'title3' => '',

            'title4' => '',

            'description1' => '',

            'description2' => '',

            'description3' => '',

            'description4' => '',

            'url1' => '',

            'url2' => '',

            'url3' => '',

            'url4' => '',

            'image1' => '',

            'image2' => '',

            'image3' => '',

            'image4' => '',

                        ), $atts));



        $output = '';



        include( get_template_directory() . '/includes/modules/shortcodes/fancy-parallax.php');



        return $output;

    }



    function mockup($atts, $contents = null) {

        extract(shortcode_atts(array(

            'image' => ''

                        ), $atts));



        $output = '<span class="mob-mockup">' . wp_get_attachment_image($image, 'full') . '</span>';



        return $output;

    }



    function contact_info($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => ''

                        ), $atts));



        $output = '<div class="info-block">

					<div class="container">	

						<div class="row">	

							<ul>';

        $output .= do_shortcode($contents);

        $output .= '</ul>

					</div>

				</div>

			</div>';



        return $output;

    }



    function contact_info_item($atts, $contents = null) {

        extract(shortcode_atts(array(

            'title' => '',

            'sub_title' => '',

            'icon' => ''

                        ), $atts));



        $output = '<li class="col-md-4">';

        $output .= ($icon) ? '<i class="fa ' . $icon . '"></i>' : '';

        $output .= ($sub_title) ? '<span>' . $sub_title . '</span>' : '';

        $output .= ($title) ? '<h5>' . $title . '</h5>' : '';

        $output .= '</li>';



        return $output;

    }



}

?>