<?php

class SH_Taxonomies
{
	function __construct()
	{
		// Hook into the 'init' action
		add_action( 'init', array($this, 'taxonomies'), 0 );
	}
	
	// Register Custom Taxonomy
	function taxonomies()  {
		$labels = array(
			'name'                       => _x( 'Portfolio Category', 'Portfolio Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Portfolio Category', 'Portfolio Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'portfolio_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'portfolio_category', 'sh_portfolio', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Testimonial Category', 'Testimonial Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'testimonial_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'testimonial_category', 'sh_testimonial', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Team Category', 'Team Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'team_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'team_category', 'sh_team', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Partner Category', 'Partner Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'partner_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'partner_category', 'sh_partner', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Event Category', 'Event Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'event_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'event_category', 'sh_event', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Job Category', 'Job Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'job_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'job_category', 'sh_jobs', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Job Application Category', 'Job Application Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'job_application_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'job_application_category', 'sh_job_application', $args );
		
		$labels = array(
			'name'                       => _x( 'Project Category', 'Project Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'job_project_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'project_category', 'sh_project', $args );
		
		$labels = array(
			'name'                       => _x( 'FAQs Category', 'Faqs Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Categry', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'job_faq_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'faq_category', 'sh_faq', $args );
		
		
		$labels = array(
			'name'                       => _x( 'Service Category', 'Service Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'service_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'service_category', 'sh_service', $args );
		
		$labels = array(
			'name'                       => _x( 'Deal Category', 'Deal Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Category', 'wp_dastak' ),
			'menu_name'                  => __( 'Category', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'deal_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'deal_category', 'sh_deal', $args );
		
		$labels = array(
			'name'                       => _x( 'Gallery Category', 'Gallery Category', 'wp_dastak' ),
			'singular_name'              => _x( 'Category', 'Categories', 'wp_dastak' ),
			'menu_name'                  => __( 'Categories', 'wp_dastak' ),
			'all_items'                  => __( 'All Categories', 'wp_dastak' ),
			'parent_item'                => __( 'Parent Category', 'wp_dastak' ),
			'parent_item_colon'          => __( 'Parent Category:', 'wp_dastak' ),
			'new_item_name'              => __( 'New Category Name', 'wp_dastak' ),
			'add_new_item'               => __( 'Add New Category', 'wp_dastak' ),
			'edit_item'                  => __( 'Edit Category', 'wp_dastak' ),
			'update_item'                => __( 'Update Category', 'wp_dastak' ),
			'separate_items_with_commas' => __( 'Separate Categories with commas', 'wp_dastak' ),
			'search_items'               => __( 'Search Categories', 'wp_dastak' ),
			'add_or_remove_items'        => __( 'Add or remove Categories', 'wp_dastak' ),
			'choose_from_most_used'      => __( 'Choose from the most used Categories', 'wp_dastak' ),
		);
	
		$rewrite = array(
			'slug'                       => 'gallery_category',
			'with_front'                 => true,
			'hierarchical'               => true,
		);
	
		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
			'rewrite'                    => $rewrite,
		);
	
		register_taxonomy( 'gallery_category', 'sh_gallery', $args );
		register_taxonomy_for_object_type('post_tag', 'sh_event');
	}
}