<?php ob_start(); ?>

<?php if( have_posts() ): ?>
<div class="portfolio-wrapper related_items">
    <?php echo ($title) ? '<h4 class="title">'.$title.'</h4>' : '';?>
    <div id="owl-related" class="owl-carousel">
        
        <?php while( have_posts() ): the_post(); ?>
            <div class="item"> 
            	<a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"> 
                	<?php $full_image = wp_get_attachment_url(get_post_thumbnail_id());
					the_post_thumbnail( '600x410', array('class'=>'lazyOwl', 'data-src'=>$full_image) ); ?>
                	<div> 
                        <?php $port_terms = wp_get_post_terms( get_the_id(), 'portfolio_category', array('fields'=>'names') ); ?>
                        
                        <?php if( $port_terms ): ?>
                        	<small><?php echo implode(', ', $port_terms ); ?></small> 
                        <?php endif; ?>
                        <span><?php the_title(); ?></span> 
                        <i class="fa fa-link"></i> 
                    </div>
                </a> 
            </div>
        <?php endwhile; ?>

    </div>
    <!-- end related_items --> 
</div>
<!-- owl-related --> 

<script>
	jQuery(document).ready(function($) {
			// Hover and Carousel on Home #1
			$('.owl-carousel > .item ').each( function() { $(this).hoverdir(); } );
				$("#owl-related").owlCarousel({
				items : 3,
				autoPlay: 3000, //Set AutoPlay to 3 seconds
				stopOnHover : true,
				lazyLoad : true,
				transitionStyle:"fade",
				navigation : true,
				pagination : false,
			});

    });
</script>

<?php endif; 

$output = ob_get_contents();
ob_end_clean();