<?php

return array(
    'title' => __('Webinane Theme Options', 'wp_dastak'),
    'logo' => 'logo.png',
    'menus' => array(
        array(
            'title' => __('General Settings', 'wp_dastak'),
            'name' => 'general_settings',
            'icon' => 'font-awesome:fa fa-cogs',
            'menus' => array(
                array(
                    'title' => __('General Settings', 'wp_dastak'),
                    'name' => 'general_settings',
                    'icon' => 'font-awesome:fa fa-cogs',
                    'controls' => array(
                        array(
                            'type' => 'toggle',
                            'name' => 'page_up_anchor',
                            'label' => __('Show Page Up Anchor', 'wp_dastak'),
                            'description' => __('Enable to show page up anchor.', 'wp_dastak'),
                            'default' => 1,
                        ),
                        array(
                            'type' => 'section',
                            'repeating' => true,
                            'sortable' => true,
                            'title' => __('Color Scheme', 'wp_dastak'),
                            'name' => 'color_schemes',
                            'description' => __('This section is used for theme color settings', 'wp_dastak'),
                            'fields' => array(
                                array(
                                    'type' => 'select',
                                    'name' => 'color_selection',
                                    'label' => __('Color Scheme', 'wp_dastak'),
                                    'description' => __('Select color scheme type default or custom', 'wp_dastak'),
                                    'items' => array(array('value' => 'custom', 'label' => 'Custom Color'), array('value' => 'default', 'label' => 'Default Color Schemes '),),
                                    'default' => 'custom'
                                ),
                                array(
                                    'type' => 'color',
                                    'name' => 'custom_color_scheme',
                                    'label' => __('Color Scheme', 'wp_dastak'),
                                    'description' => __('Choose the custom color scheme for the theme.', 'wp_dastak'),
                                    'default' => '#EC644B',
                                    'dependency' => array(
                                        'field' => 'color_selection',
                                        'function' => 'vp_dep_is_custom',
                                    ),
                                ),
                                array(
                                    'type' => 'select',
                                    'name' => 'default_color_scheme',
                                    'label' => __('Color Scheme', 'wp_dastak'),
                                    'description' => __('Choose the default color schemes for the theme.', 'wp_dastak'),
                                    'deafault' => 'no',
                                    'items' => array(
                                        array('value' => 'no', 'label' => 'No Color'),
                                        array('value' => 'blue', 'label' => 'Blue'),
                                        array('value' => 'brown', 'label' => 'Brown'),
                                        array('value' => 'gray', 'label' => 'Gray'),
                                        array('value' => 'green', 'label' => 'Green'),
                                        array('value' => 'lime', 'label' => 'Lime'),
                                        array('value' => 'orange', 'label' => 'Orange'),
                                        array('value' => 'pink', 'label' => 'Pink'),
                                        array('value' => 'purple', 'label' => 'Purple'),
                                        array('value' => 'red', 'label' => 'Red'),
                                        array('value' => 'teal', 'label' => 'Teal'),
                                        array('value' => 'yellow', 'label' => 'Yellow'),
                                    ),
                                    'dependency' => array(
                                        'field' => 'color_selection',
                                        'function' => 'vp_dep_is_default',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'section',
                            'repeating' => true,
                            'sortable' => true,
                            'title' => __('Layout Settings', 'wp_dastak'),
                            'name' => 'layout_settings',
                            'description' => __('This section is used for site layout settings', 'wp_dastak'),
                            'fields' => array(
                                array(
                                    'type' => 'toggle',
                                    'name' => 'site_rtl',
                                    'label' => __('RTL', 'wp_dastak'),
                                    'description' => __('Enable to make site text from right to left for multilingual sites', 'wp_dastak'),
                                ),
                                array(
                                    'type' => 'toggle',
                                    'name' => 'boxed_layout_status',
                                    'label' => __('Boxed Layout', 'wp_dastak'),
                                    'description' => __('Enable to make the layout in boxed version', 'wp_dastak'),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'section',
                            'repeating' => false,
                            'sortable' => true,
                            'title' => __('Background Settings', 'wp_dastak'),
                            'name' => 'background_image_settings',
                            'description' => __('This section is used for box layout background settings', 'wp_dastak'),
                            'dependency' => array(
                                'field' => 'boxed_layout_status',
                                'function' => 'vp_dep_boolean',
                            ),
                            'fields' => array(
                                array(
                                    'type' => 'radiobutton',
                                    'name' => 'background_type',
                                    'label' => __('Background Type', 'wp_dastak'),
                                    'items' => array(
                                        array(
                                            'value' => 'image',
                                            'label' => __('Image', 'wp_dastak'),
                                        ),
                                        array(
                                            'value' => 'pattern',
                                            'label' => __('Pattern', 'wp_dastak'),
                                        ),
                                    ),
                                    'default' => array(
                                        'image',
                                    ),
                                ),
                                array(
                                    'type' => 'upload',
                                    'name' => 'background_image',
                                    'label' => __('Backegound Image', 'wp_dastak'),
                                    'description' => __('Insert background image', 'wp_dastak'),
                                    'default' => '',
                                    'dependency' => array(
                                        'field' => 'background_type',
                                        'function' => 'vp_dep_is_image',
                                    ),
                                ),
                                array(
                                    'type' => 'select',
                                    'name' => 'background_repeat',
                                    'label' => __('Background Repeat', 'wp_dastak'),
                                    'description' => __('Select to repeat the background or not', 'wp_dastak'),
                                    'items' => array(array('value' => 'repeat', 'label' => 'Repeat'), array('value' => 'no-repeat', 'label' => 'No Repeat'),),
                                    'default' => 'no-repeat',
                                    'dependency' => array(
                                        'field' => 'background_type',
                                        'function' => 'vp_dep_is_image',
                                    ),
                                ),
                                array(
                                    'type' => 'select',
                                    'name' => 'background_attachment',
                                    'label' => __('Background Attachment', 'wp_dastak'),
                                    'description' => __('Select background attachment to fixed or scroll the image', 'wp_dastak'),
                                    'items' => array(array('value' => 'fixed', 'label' => 'Fixed'), array('value' => 'scroll', 'label' => 'Scroll'),),
                                    'default' => 'fixed',
                                    'dependency' => array(
                                        'field' => 'background_type',
                                        'function' => 'vp_dep_is_image',
                                    ),
                                ),
                                array(
                                    'type' => 'color',
                                    'name' => 'background_color',
                                    'label' => __('Background Color', 'wp_dastak'),
                                    'description' => __('Choose the background color for patterns', 'wp_dastak'),
                                    'default' => '',
                                    'dependency' => array(
                                        'field' => 'background_type',
                                        'function' => 'vp_dep_is_pattern',
                                    ),
                                ),
                                array(
                                    'type' => 'radioimage',
                                    'name' => 'patterns',
                                    'label' => __('Select Patterns', 'wp_dastak'),
                                    'description' => __('Choose the patterns for boxed version', 'wp_dastak'),
                                    'items' => array(
                                        array(
                                            'value' => 'pattern-1',
                                            'label' => __('Pattern 1', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-1.png',
                                        ),
                                        array(
                                            'value' => 'pattern-2',
                                            'label' => __('Pattern 2', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-2.png',
                                        ),
                                        array(
                                            'value' => 'pattern-3',
                                            'label' => __('Pattern 3', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-3.png',
                                        ),
                                        array(
                                            'value' => 'pattern-4',
                                            'label' => __('Pattern 4', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-4.png',
                                        ),
                                        array(
                                            'value' => 'pattern-5',
                                            'label' => __('Pattern 5', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-5.png',
                                        ),
                                        array(
                                            'value' => 'pattern-6',
                                            'label' => __('Pattern 6', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-6.png',
                                        ),
                                        array(
                                            'value' => 'pattern-7',
                                            'label' => __('Pattern 7', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-7.png',
                                        ),
                                        array(
                                            'value' => 'pattern-8',
                                            'label' => __('Pattern 8', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-8.png',
                                        ),
                                        array(
                                            'value' => 'pattern-9',
                                            'label' => __('Pattern 9', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-9.png',
                                        ),
                                        array(
                                            'value' => 'pattern-10',
                                            'label' => __('Pattern 10', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-10.png',
                                        ),
                                        array(
                                            'value' => 'pattern-11',
                                            'label' => __('Pattern 11', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-11.png',
                                        ),
                                        array(
                                            'value' => 'pattern-12',
                                            'label' => __('Pattern 12', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-12.png',
                                        ),
                                        array(
                                            'value' => 'pattern-13',
                                            'label' => __('Pattern 13', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-13.png',
                                        ),
                                        array(
                                            'value' => 'pattern-14',
                                            'label' => __('Pattern 14', 'wp_dastak'),
                                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/patterns/pattern-14.png',
                                        ),
                                    ),
'dependency' => array(
    'field' => 'background_type',
    'function' => 'vp_dep_is_pattern',
),
),
),
),
array(
    'type' => 'section',
    'title' => __('Twitter Settings', 'wp_dastak'),
    'name' => 'twitter_settings',
    'description' => __('This section contain the information about twitter api settings', 'wp_dastak'),
    'fields' => array(
        array(
            'type' => 'textbox',
            'name' => 'api',
            'label' => __('API Key', 'wp_dastak'),
            'description' => __('Enter the twitter API key, You can get the api at <a href="http://developer.twitter.com">http://developer.twitter.com</a>', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'textbox',
            'name' => 'api_secret',
            'label' => __('API Secret', 'wp_dastak'),
            'description' => __('Enter the API secret', 'wp_dastak'),
            'default' => '',
        ),
                               /* array(
                                    'type' => 'textbox',
                                    'name' => 'token',
                                    'label' => __('Token', 'wp_dastak'),
                                    'description' => __('Enter the Twitter API token', 'wp_dastak'),
                                    'default' => '',
                                ),
                                array(
                                    'type' => 'textbox',
                                    'name' => 'token_secret',
                                    'label' => __('Token Secret', 'wp_dastak'),
                                    'description' => __('Enter the API token secret', 'wp_dastak'),
                                    'default' => '',
                                ),*/
                            ),
),
array(
    'type' => 'section',
    'title' => __('Recaptcha API', 'wp_dastak'),
    'name' => 'recaptcha_api',
    'description' => __('Get the recaptcha apis from https://www.google.com/recaptcha/admin/create', 'wp_dastak'),
    'fields' => array(
        array(
            'type' => 'textbox',
            'name' => 'recaptcha_public',
            'label' => __('Public Key', 'wp_dastak'),
            'description' => __('Enter the recaptcha public key', 'wp_dastak'),
            'description' => '',
            'default' => '',
        ),
        array(
            'type' => 'textbox',
            'name' => 'recaptcha_private',
            'label' => __('Private Key', 'wp_dastak'),
            'description' => __('Enter the private key', 'wp_dastak'),
            'default' => '',
        ),
    ),
),
array(
    'type' => 'section',
    'title' => __('Forgot Password Page Section', 'wp_dastak'),
    'name' => 'forgot_password',
    'description' => __('Forgot password page settings', 'wp_dastak'),
    'fields' => array(
        array(
            'type' => 'upload',
            'name' => 'forgot_password_image',
            'label' => __('Backgorunnd Image', 'wp_dastak'),
            'description' => __('Insert the forgot password page background image', 'wp_dastak'),
            'default' => ''
        ),
    ),
),
array(
    'type' => 'section',
    'title' => __('Registration Page Section', 'wp_dastak'),
    'name' => 'registration',
    'description' => __('Registration page settings', 'wp_dastak'),
    'fields' => array(
        array(
            'type' => 'upload',
            'name' => 'register_image',
            'label' => __('Backgorunnd Image', 'wp_dastak'),
            'description' => __('Insert the registration page background image', 'wp_dastak'),
            'default' => ''
        ),
        array(
            'type' => 'textbox',
            'name' => 'register_title',
            'label' => __('Title', 'wp_dastak'),
            'description' => __('Enter the title for registration box', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'textarea',
            'name' => 'register_description',
            'label' => __('Description', 'wp_dastak'),
            'description' => __('Enter the description for registration box', 'wp_dastak'),
            'default' => '',
        ),
    ),
),
),
),
                // One page settings
array(
    'title' => __('One Page Settings', 'wp_dastak'),
    'name' => 'one_page_setting_sub_menu',
    'icon' => 'font-awesome:fa fa-th-large',
    'controls' => array(
        array(
            'type' => 'toggle',
            'name' => 'one_page',
            'label' => __('Enable One Page', 'wp_dastak'),
        ),
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Section', 'wp_dastak'),
            'name' => 'one_page_settings',
            'dependency' =>
            array(
                'field' => 'one_page',
                'function' => 'vp_dep_boolean',
            ),
            'fields' => array(
                array(
                    'type' => 'select',
                    'name' => 'select_page_section',
                    'label' => __('Select Page', 'wp_dastak'),
                    'description' => __('Choose any Page which you want to add as a Section on One Page.', 'wp_dastak'),
                    'default' => __('Pages', 'wp_dastak'),
                    'items' => array(
                        'data' => array(
                            array(
                                'source' => 'function',
                                'value' => 'vp_get_pages',
                            ),
                        ),
                    ),
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'menu_name',
                    'label' => __('Menu Label', 'wp_dastak'),
                    'description' => __('Enter the Label you want to display in One Page Menu.', 'wp_dastak'),
                ),
                array(
                    'type' => 'fontawesome',
                    'name' => 'menu_icon',
                    'label' => __('Menu Icon', 'wp_dastak'),
                    'description' => __('Choose icon for menu header style 2.', 'wp_dastak'),
                ),
            ),
        ),
    ),
),
/** Submenu for heading settings */
array(
    'title' => __('Header Settings', 'wp_dastak'),
    'name' => 'header_settings',
    'icon' => 'font-awesome:fa fa-strikethrough',
    'controls' => array(
        array(
            'type' => 'radioimage',
            'name' => 'header_style',
            'label' => __('Choose Header', 'wp_dastak'),
            'item_max_height' => '150',
            'item_max_width' => '400',
            'items' => array(
                array(
                    'value' => 'style1',
                    'label' => __('Header Style One', 'wp_dastak'),
                    'img' => SH_URL . 'images/1.jpg',
                ),
                array(
                    'value' => 'style2',
                    'label' => __('Header Style Two', 'wp_dastak'),
                    'img' => SH_URL . 'images/2.png',
                ),
                array(
                    'value' => 'style3',
                    'label' => __('Header Style Three', 'wp_dastak'),
                    'img' => SH_URL . 'images/3.png',
                ),
                array(
                    'value' => 'style4',
                    'label' => __('Header Style Four', 'wp_dastak'),
                    'img' => SH_URL . 'images/4.png',
                ),
            ),
        ),
        array(
            'type' => 'select',
            'name' => 'header_color_scheme',
            'label' => __('Header Color Scheme', 'wp_dastak'),
            'description' => __('Choose header color scheme either dark or light', 'wp_dastak'),
            'items' => array(array('value' => 'whitish', 'label' => 'White'), array('value' => 'blackish', 'label' => 'Black'), array('value' => '', 'label' => 'Transparent')),
            'default' => '',
            'dependency' => array(
                'field' => 'header_style',
                'function' => 'vp_dep_is_style4',
            ),
        ),
        array(
            'type' => 'toggle',
            'name' => 'show_cart',
            'label' => __('Show Cart', 'wp_dastak'),
            'description' => __('Enable to show cart in header section <br> Note: This option will work for header style one and two', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'toggle',
            'name' => 'login_botton',
            'label' => __('Login Button', 'wp_dastak'),
            'description' => __('Enable/Disable login button in header section <br> Note: This option will work for header style one and two', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'toggle',
            'name' => 'search_bar',
            'label' => __('Search Bar', 'wp_dastak'),
            'description' => __('Enable Disable search bar to show in header', 'wp_dastak'),
            'dependency' => array(
                'field' => 'header_style',
                'function' => 'vp_dep_is_style1',
            ),
            'default' => '',
        ),
        array(
            'type' => 'toggle',
            'name' => 'header_social_icons',
            'label' => __('Social Icons', 'wp_dastak'),
            'description' => __('Enable Disable social icons to show in header <br> Note: This option will work for header style one and two', 'wp_dastak'),
        ),
        array(
            'type' => 'toggle',
            'name' => 'header_sticky_menu',
            'label' => __('Sticky Menu', 'wp_dastak'),
            'description' => __('Enable Disable to show sticky menu in header', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'textbox',
            'name' => 'header_email',
            'label' => __('Header Eamil', 'wp_dastak'),
            'description' => __('Enter the email to show in header section <br> Note: This option will work for header style one and two', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'textbox',
            'name' => 'header_phone',
            'label' => __('Header Phone Number', 'wp_dastak'),
            'description' => __('Enter the phone number to show in header section <br> Note: This option will work for header style one and two', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'upload',
            'name' => 'favicon',
            'label' => __('Favicon', 'wp_dastak'),
            'description' => __('Upload the favicon, should be 16x16', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'select',
            'name' => 'logo_type',
            'label' => __('Logo Type', 'wp_dastak'),
            'description' => __('Choose logo type', 'wp_dastak'),
            'items' => array(array('value' => 'text', 'label' => 'Logo With Text'), array('value' => 'image', 'label' => 'Logo With Image'),),
            'default' => 'logo'
        ),
        array(
            'type' => 'section',
            'title' => __('Logo with Image', 'wp_dastak'),
            'name' => 'logo_with_image',
            'dependency' => array(
                'field' => 'logo_type',
                'function' => 'vp_dep_is_logo',
            ),
            'fields' => array(
                array(
                    'type' => 'upload',
                    'name' => 'logo_image',
                    'label' => __('Logo Image', 'wp_dastak'),
                    'description' => __('Inser the logo image', 'wp_dastak'),
                    'default' => get_template_directory_uri() . '/images/logo.png'
                ),
                array(
                    'type' => 'slider',
                    'name' => 'logo_width',
                    'label' => __('Logo Width', 'wp_dastak'),
                    'description' => __('choose the logo width', 'wp_dastak'),
                    'default' => '144',
                    'mix' => 20,
                    'max' => 400
                ),
                array(
                    'type' => 'slider',
                    'name' => 'logo_height',
                    'label' => __('Logo Height', 'wp_dastak'),
                    'description' => __('choose the logo height', 'wp_dastak'),
                    'default' => '45',
                    'mix' => 20,
                    'max' => 400
                ),
            ),
        ),
        array(
            'type' => 'section',
            'title' => __('Custom Logo Text', 'wp_dastak'),
            'name' => 'section_custom_logo_text',
            'dependency' => array(
                'field' => 'logo_type',
                'function' => 'vp_dep_is_text',
            ),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'logo_heading',
                    'label' => __('Logo Heading', 'wp_dastak'),
                    'description' => __('Enter the website heading instead of logo', 'wp_dastak'),
                    'default' => 'Aplus'
                ),
                array(
                    'type' => 'slider',
                    'name' => 'logo_font_size',
                    'label' => __('Logo Font Size', 'wp_dastak'),
                    'description' => __('Choose the logo font size', 'wp_dastak'),
                    'default' => 40,
                    'min' => 12,
                    'max' => 45
                ),
                array(
                    'type' => 'select',
                    'name' => 'logo_font_face',
                    'label' => __('Logo Font Face', 'wp_dastak'),
                    'description' => __('Select Font', 'wp_dastak'),
                    'items' => array(
                        'data' => array(
                            array(
                                'source' => 'function',
                                'value' => 'vp_get_gwf_family',
                            ),
                        ),
                    ),
                ),
                array(
                    'type' => 'radiobutton',
                    'name' => 'logo_font_style',
                    'label' => __('Logo Font Style', 'wp_dastak'),
                    'description' => __('Select Font Style', 'wp_dastak'),
                    'items' => array(
                        'data' => array(
                            array(
                                'source' => 'binding',
                                'field' => 'logo_font_face',
                                'value' => 'vp_get_gwf_style',
                            ),
                        ),
                    ),
                    'default' => array(
                        '{{first}}',
                    ),
                ),
                array(
                    'type' => 'color',
                    'name' => 'logo_color',
                    'label' => __('Logo Color', 'wp_dastak'),
                    'description' => __('Choose the default color for logo.', 'wp_dastak'),
                    'default' => '#98ed28',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'slogan_heading',
                    'label' => __('Slogan Heading', 'wp_dastak'),
                    'description' => __('Enter the slogan', 'wp_dastak'),
                    'default' => 'Multipurpose Wordpress theme'
                ),
                array(
                    'type' => 'slider',
                    'name' => 'slogan_font_size',
                    'label' => __('Slogan Font Size', 'wp_dastak'),
                    'description' => __('Choose the slogan font size', 'wp_dastak'),
                    'default' => 40,
                    'min' => 12,
                    'max' => 45
                ),
                array(
                    'type' => 'select',
                    'name' => 'slogan_font_face',
                    'label' => __('Slogan Font Face', 'wp_dastak'),
                    'description' => __('Select Font', 'wp_dastak'),
                    'items' => array(
                        'data' => array(
                            array(
                                'source' => 'function',
                                'value' => 'vp_get_gwf_family',
                            ),
                        ),
                    ),
                ),
                array(
                    'type' => 'radiobutton',
                    'name' => 'slogan_font_style',
                    'label' => __('Slogan Font Style', 'wp_dastak'),
                    'description' => __('Select Font Style', 'wp_dastak'),
                    'items' => array(
                        'data' => array(
                            array(
                                'source' => 'binding',
                                'field' => 'slogan_font_face',
                                'value' => 'vp_get_gwf_style',
                            ),
                        ),
                    ),
                    'default' => array(
                        '{{first}}',
                    ),
                ),
                array(
                    'type' => 'color',
                    'name' => 'slogan_color',
                    'label' => __('Slogan Color', 'wp_dastak'),
                    'description' => __('Choose the default color for slogan.', 'wp_dastak'),
                    'default' => '#98ed28',
                ),
            ),
),
array(
    'type' => 'codeeditor',
    'name' => 'header_css',
    'label' => __('Header CSS', 'wp_dastak'),
    'description' => __('Write your custom css to include in header.', 'wp_dastak'),
    'theme' => 'github',
    'mode' => 'css',
),
array(
    'type' => 'codeeditor',
    'name' => 'header_js',
    'label' => __('Header JS', 'wp_dastak'),
    'description' => __('Write your custom js to include in header.', 'wp_dastak'),
    'theme' => 'twilight',
    'mode' => 'javascript',
),
),
),
/** Submenu for footer area */
array(
    'title' => __('Footer Settings', 'wp_dastak'),
    'name' => 'footer_settings',
    'icon' => 'font-awesome:fa fa-gear',
    'controls' => array(
        array(
            'name' => 'footer_banner_status',
            'label' => 'Enable to show footer banner section',
            'type' => 'toggle',

        ),
        array(
            'type' => 'section',
            'title' => __('Footer Parallax Section', 'wp_dastak'),
            'name' => 'footer_banner',
            'description' => __('Footer parallax section', 'wp_dastak'),
            'dependency' => array(
                'field' => 'footer_banner_status',
                'function' => 'vp_dep_boolean',
            ),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'footer_banner_title',
                    'label' => __('Footer Parallax Title', 'wp_dastak'),
                    'description' => __('Enter the footer parallax title', 'wp_dastak'),
                    'default' => '',
                ),
                array(
                    'type' => 'textarea',
                    'name' => 'footer_banner_text',
                    'label' => __('Footer Parallax Description', 'wp_dastak'),
                    'description' => __('Enter the footer parallax description to show in footer area', 'wp_dastak'),
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'footer_banner_button',
                    'label' => __('Footer Parallax Button Label', 'wp_dastak'),
                    'description' => __('Enter the footer parallax button label', 'wp_dastak'),
                    'default' => 'Request Free Quote',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'footer_banner_url',
                    'label' => __('Footer Parallax Button URL', 'wp_dastak'),
                    'description' => __('Enter the footer parallax button url', 'wp_dastak'),
                    'default' => '#',
                ),
                array(
                    'type' => 'upload',
                    'name' => 'footer_banner',
                    'label' => __('Footer Parallax Image', 'wp_dastak'),
                    'description' => __('Upload footer parallax image <br> Note: Minimum size reuired 1500x700', 'wp_dastak'),
                    'default' => '',
                ),
            )
        ),
        array(
            'type' => 'textarea',
            'name' => 'copyright_text',
            'label' => __('Footer Copyright Text', 'wp_dastak'),
            'description' => __('Enter the copyright text to show in footer area', 'wp_dastak'),
        ),
        array(
            'type' => 'codeeditor',
            'name' => 'footer_js',
            'label' => __('Footer JS', 'wp_dastak'),
            'description' => __('Write your custom js to include in footer.', 'wp_dastak'),
            'theme' => 'twilight',
            'mode' => 'javascript',
        ),
    )
                ), //End of submenu
array(
    'title' => __('Footer Sidebar Settings', 'wp_dastak'),
    'name' => 'footer-sidebar-settings',
    'icon' => 'font-awesome:fa fa-envelope',
    'controls' => array(
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Footer Dynamic Sidebar', 'wp_dastak'),
            'name' => 'footer_dynamic_sidebar',
            'description' => __('This section is used for sidebars builder', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'sidebar_name',
                    'label' => __('Sidebar Name', 'wp_dastak'),
                    'description' => __('Enter the sidebar name.', 'wp_dastak'),
                    'default' => __('Dynamic Sidebar', 'wp_dastak'),
                ),
                array(
                    'type' => 'select',
                    'label' => __('Footer Sidebar Grid', 'wp_dastak'),
                    'name' => 'footer_sidebar_grid',
                    'description' => __('Select the blog list style', 'wp_dastak'),
                    'items' => array(array('value' => '12', 'label' => esc_html__('1/1 Grid', 'wp_dastak')), array('value' => '10', 'label' => esc_html__('5/6 Grid', 'wp_dastak')), array('value' => '9', 'label' => esc_html__('3/4 Grid', 'wp_dastak')), array('value' => '8', 'label' => esc_html__('2/3 Grid', 'wp_dastak')), array('value' => '7', 'label' => esc_html__('12/7 Grid', 'wp_dastak')), array('value' => '6', 'label' => esc_html__('1/2 Grid', 'wp_dastak')), array('value' => '5', 'label' => esc_html__('12/5 Grid', 'wp_dastak')), array('value' => '4', 'label' => esc_html__('1/3 Grid', 'wp_dastak')), array('value' => '3', 'label' => esc_html__('1/4 Grid', 'wp_dastak')), array('value' => '2', 'label' => esc_html__('1/6', 'wp_dastak'))),
                    'description' => __('Select footer sidebar grid to show its widget', 'wp_dastak'),
                ),
            ),
        ),
    )
),
array(
    'title' => __('Related Services Settings', 'wp_dastak'),
    'name' => 'related-services-settings',
    'icon' => 'font-awesome:fa fa-envelope',
    'controls' => array(
        array(
            'type' => 'textbox',
            'name' => 'related_services_title',
            'label' => __('Related Services Section Title', 'wp_dastak'),
            'description' => __('Enter the title for related services to show on service detail page.', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'textbox',
            'name' => 'related_services_num',
            'label' => __('Related Services Number', 'wp_dastak'),
            'description' => __('Enter the number of related services to show on service detail page.', 'wp_dastak'),
            'default' => '',
        ),
        array(
            'type' => 'select',
            'name' => 'related_services_cols',
            'label' => __('Number of Columns', 'wp_dastak'),
            'default' => '',
            'items' => array(array('value' => '6', 'label' => 'Two Columns'), array('value' => '4', 'label' => 'Three Columns'), array('value' => '3', 'label' => 'Four Columns'))
        ),
    )
),
/** Contact Settings */
array(
    'title' => __('Sidebar Settings', 'wp_dastak'),
    'name' => 'sidebar-settings',
    'icon' => 'font-awesome:fa fa-envelope',
    'controls' => array(
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Dynamic Sidebar', 'wp_dastak'),
            'name' => 'dynamic_sidebar',
            'description' => __('This section is used for theme color settings', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'sidebar_name',
                    'label' => __('Sidebar Name', 'wp_dastak'),
                    'description' => __('Enter the sidebar name.', 'wp_dastak'),
                    'default' => __('Dynamic Sidebar', 'wp_dastak'),
                ),
            ),
        ),
    )
),
),
),
/** Blog Listing Settings */
array(
    'title' => __('Blog Settings', 'wp_dastak'),
    'name' => 'blog_page_settings',
    'icon' => 'font-awesome:fa fa-rss',
    'controls' => array(
        array(
            'type' => 'section',
            'repeating' => false,
            'sortable' => false,
            'title' => __('Blog Settings', 'wp_dastak'),
            'name' => 'blog_settings',
            'description' => __('These options will work when you will not set static page option under reading section', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'radioimage',
                    'name' => 'blog_sidebar_layout',
                    'label' => __('Blog Listing Layout', 'wp_dastak'),
                    'description' => __('Choose the layout for blog pages', 'wp_dastak'),
                    'items' => array(
                        array(
                            'value' => 'left',
                            'label' => __('Blog with Left Sidebar', 'wp_dastak'),
                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/2cl.png',
                        ),
                        array(
                            'value' => 'right',
                            'label' => __('Blog with Right Sidebar', 'wp_dastak'),
                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/2cr.png',
                        ),
                        array(
                            'value' => 'full',
                            'label' => __('Full Width', 'wp_dastak'),
                            'img' => get_template_directory_uri() . '/includes/vafpress/public/img/1col.png',
                        ),
                    ),
                ),
                array(
                    'type' => 'select',
                    'name' => 'blog_pages_sidebar',
                    'label' => __('Sidebar', 'wp_dastak'),
                    'default' => array(
                        'default-sidebar',
                    ),
                    'items' => sh_get_sidebars(true),
                    'dependency' => array(
                        'field' => 'blog_sidebar_layout',
                        'function' => 'vp_dep_sidebar_boolean',
                    ),
                ),
                array(
                    'type' => 'select',
                    'label' => __('Blog Style', 'wp_dastak'),
                    'name' => 'blog_style',
                    'description' => __('Select the blog list style', 'wp_dastak'),
                    'items' => array(array('value' => 'style1', 'label' => 'Style One'), array('value' => 'style2', 'label' => 'Style Two')
                ),
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'blog_page_title',
                    'label' => __('Blog Page Title', 'wp_dastak'),
                    'description' => __('Enter the title for blog page.', 'wp_dastak'),
                    'default' => '',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'blog_page_subtitle',
                    'label' => __('Blog Page Subtitle', 'wp_dastak'),
                    'description' => __('Enter the subtitle for blog page.', 'wp_dastak'),
                    'default' => '',
                ),
                array(
                    'type' => 'upload',
                    'name' => 'blog_header_banner',
                    'label' => __('Blog Page Header Image', 'wp_dastak'),
                    'description' => __('Choose the header banner image to show on blog pages', 'wp_dastak'),
                ),
                array(
                    'type' => 'upload',
                    'name' => 'pagination_background',
                    'label' => __('Pagination Background Image', 'wp_dastak'),
                    'description' => __('Choose the pagination background image', 'wp_dastak'),
                )
            ),
        ),
    )
),
/* Product Page Settings */
array(
    'title' => __('Product Page Settings', 'wp_dastak'),
    'name' => 'products_Settings',
    'icon' => 'font-awesome:fa fa-envelope',
    'controls' => array(
        array(
            'type' => 'select',
            'name' => 'product_page_style',
            'label' => __('Product Page Style', 'wp_dastak'),
            'default' => '',
            'items' => array(array('value' => '1', 'label' => 'Grid Style One'), array('value' => '2', 'label' => 'Grid Style Two'))
        ),
        array(
            'type' => 'select',
            'name' => 'product_page_title',
            'label' => __('Product Page Title Style', 'wp_dastak'),
            'default' => '',
            'items' => array(array('value' => '1', 'label' => 'Title Style One'), array('value' => '2', 'label' => 'Title Style Two'), array('value' => '3', 'label' => 'Title Style Three'), array('value' => '4', 'label' => 'Title Style Four'), array('value' => '5', 'label' => 'Title Style Five'))
        ),
        array(
            'type' => 'select',
            'name' => 'product_page_cols',
            'label' => __('Number of Grids', 'wp_dastak'),
            'default' => '',
            'items' => array(array('value' => '3', 'label' => 'Grid 1/4 '), array('value' => '4', 'label' => 'Grid 1/3 '), array('value' => '6', 'label' => 'Grid 1/2 '),)
        ),
        array(
            'type' => 'toggle',
            'name' => 'enable_product_wishlist',
            'label' => __('Show Add to wishlist', 'wp_dastak'),
            'default' => 1,
        ),
        array(
            'type' => 'toggle',
            'name' => 'enable_product_cart',
            'label' => __('Show Add to cart button', 'wp_dastak'),
            'default' => 1,
        ),
        array(
            'type' => 'section',
            'title' => __('Product Detail Settings', 'wp_dastak'),
            'name' => 'product_detail_settings',
            'description' => __('This section contain the information about product detail page settings', 'wp_dastak'),
            'fields' => array(
               array(
                'type' => 'toggle',
                'name' => 'enable_product_single_wishlist',
                'label' => __('Show Add to wishlist', 'wp_dastak'),
                'default' => 1,
            ),
           ),
        ),
    ),
    ),
    /** Social Network Settings */
    array(
        'title' => __('Socializing Settings', 'wp_dastak'),
        'name' => 'socializing_settings',
        'icon' => 'font-awesome:fa fa-link',
        'controls' => array(
            array(
                'type' => 'builder',
                'repeating' => true,
                'sortable' => true,
                'label' => __('Social Icons', 'wp_dastak'),
                'name' => 'social_icons',
                'description' => __('This section is used for theme color settings', 'wp_dastak'),
                'fields' => array(
                    array(
                        'type' => 'select',
                        'name' => 'icon',
                        'label' => __('Social Icon', 'wp_dastak'),
                        'default' => 'facebook',
                        'items' => array(
                            'data' => array(
                                array(
                                    'source' => 'function',
                                    'value' => 'vp_get_social_medias',
                                ),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'textbox',
                        'name' => 'title',
                        'label' => __('Title', 'wp_dastak'),
                        'default' => '',
                    ),
                    array(
                        'type' => 'textbox',
                        'name' => 'link',
                        'label' => __('URL', 'wp_dastak'),
                        'default' => '',
                    ),
                ),
            ),
        )
    ),
    /** Offices Settings */
    array(
        'title' => __('Offices Settings', 'wp_dastak'),
        'name' => 'offices_settings',
        'icon' => 'font-awesome:fa fa-home',
        'controls' => array(
            array(
                'type' => 'builder',
                'repeating' => true,
                'sortable' => true,
                'label' => __('Office', 'wp_dastak'),
                'name' => 'offices',
                'description' => __('This section is used for offices', 'wp_dastak'),
                'fields' => array(
                    array(
                        'type' => 'textbox',
                        'name' => 'title',
                        'label' => __('Title', 'wp_dastak'),
                        'default' => '',
                    ),
                    array(
                        'type' => 'textbox',
                        'name' => 'country',
                        'label' => __('Country', 'wp_dastak'),
                        'default' => '',
                    ),
                    array(
                        'type' => 'textarea',
                        'name' => 'address',
                        'label' => __('Address', 'wp_dastak'),
                        'default' => '',
                    ),
                    array(
                        'type' => 'textbox',
                        'name' => 'phone',
                        'label' => __('Phone', 'wp_dastak'),
                        'default' => '',
                    ),
                    array(
                        'type' => 'textbox',
                        'name' => 'fax',
                        'label' => __('Fax', 'wp_dastak'),
                        'default' => '',
                    ),
                    array(
                        'type' => 'upload',
                        'name' => 'image',
                        'label' => __('Image', 'wp_dastak'),
                        'default' => '',
                    ),
                ),
            ),
        )
    ),
    /** 404 Page Settings */
    array(
        'title' => __('404 Page Settings', 'wp_dastak'),
        'name' => '404_page_settings',
        'icon' => 'font-awesome:fa fa-exclamation',
        'controls' => array(
            array(
                'type' => 'upload',
                'name' => '404_page_header_image',
                'label' => __('Header Image', 'wp_dastak'),
                'default' => '',
            ),
            array(
                'type' => 'textbox',
                'name' => '404_title',
                'label' => __('Title', 'wp_dastak'),
                'default' => __('404 Not Found', 'wp_dastak'),
            ),
            array(
                'type' => 'textarea',
                'name' => '404_description',
                'label' => __('404 Message', 'wp_dastak'),
                'default' => '',
            ),
            array(
                'type' => 'upload',
                'name' => '404_image',
                'label' => __('404 Image', 'wp_dastak'),
                'default' => '',
            ),
            array(
                'type' => 'toggle',
                'name' => '404_home_button',
                'label' => __('Show Homepage Link', 'wp_dastak'),
                'default' => 1,
            ),
            /* array(
              'type' => 'select',
              'name' => '404_sidebar',
              'label' => __('Sidebar', 'wp_dastak'),
              'default' => array(
              '{{value}}',
              ),
              'items' => sh_get_sidebars(true),
          ), */
      )
    ),
    /** Portfolio Settings */
    array(
        'title' => __('Portfolio Settings', 'wp_dastak'),
        'name' => 'portfolio_settings',
        'icon' => 'font-awesome:fa fa-briefcase',
        'controls' => array(
            array(
                'type' => 'select',
                'name' => 'columns',
                'label' => __('Columns', 'wp_dastak'),
                'description' => __('Choose Number of columns for Portfolio Page', 'wp_dastak'),
                'items' => array(array('value' => '2column', 'label' => '2 Columns'), array('value' => '3column', 'label' => '3 Column'), array('value' => '4column', 'label' => '4 Column'),),
                'default' => '2column'
            ),
            array(
                'type' => 'textbox',
                'name' => 'portfolio_per_page',
                'label' => __('Per Page', 'wp_dastak'),
                'description' => __('Enter the number of portofolio per page', 'wp_dastak'),
                'default' => '10'
            )
        )
    ),
    /*         * Job Settings */
    array(
        'title' => __('Job Settings', 'wp_dastak'),
        'name' => 'job_settings',
        'icon' => 'font-awesome:fa fa-pencil',
        'controls' => array(
            array(
                'type' => 'select',
                'name' => 'application_page',
                'label' => __('Job Application Page', 'wp_dastak'),
                'description' => __('Choose page for job application', 'wp_dastak'),
                'items' => sh_get_posts_array2('page', true),
                'default' => ''
            ),
        )
    ),
    /** Mega Menu Settings */
    array(
        'title' => __('Mega Menu Settings', 'wp_dastak'),
        'name' => 'mega_menu_settings',
        'icon' => 'font-awesome:fa fa-cogs',
        'menus' => array(
            array(
                'title' => __('Mega Menu Container Settings', 'wp_dastak'),
                'name' => 'mega_menu_container_settings',
                'icon' => 'font-awesome:fa fa-minus',
                'controls' => array(
                    array(
                        'type' => 'builder',
                        'repeating' => true,
                        'sortable' => true,
                        'label' => __('Mega Menu Container', 'wp_dastak'),
                        'name' => 'meg_menu_container',
                        'description' => __('This section is used for mega menu container shortcode settings', 'wp_dastak'),
                        'fields' => array(
                            array(
                                'type' => 'radiobutton',
                                'name' => 'style',
                                'label' => __('Mega Menu Style', 'wp_dastak'),
                                'items' => array(
                                    array(
                                        'value' => 'style1',
                                        'label' => __('Full Width With Two Images', 'wp_dastak'),
                                    ),
                                    array(
                                        'value' => 'style2',
                                        'label' => __('Full Width With One Image', 'wp_dastak'),
                                    ),
                                    array(
                                        'value' => 'style3',
                                        'label' => __('Fixed Width', 'wp_dastak'),
                                    ),
                                ),
                                'default' => array(
                                    'style1',
                                ),
                            ),
                            array(
                                'type' => 'radiobutton',
                                'name' => 'position',
                                'label' => __('Mega Menu Postion', 'wp_dastak'),
                                'dependency' => array(
                                    'field' => 'style',
                                    'function' => 'vp_dep_is_style3',
                                ),
                                'items' => array(
                                    array(
                                        'value' => 'left',
                                        'label' => __('Left', 'wp_dastak'),
                                    ),
                                    array(
                                        'value' => 'center',
                                        'label' => __('Center', 'wp_dastak'),
                                    ),
                                    array(
                                        'value' => 'right',
                                        'label' => __('Right', 'wp_dastak'),
                                    ),
                                ),
                            ),
                            array(
                                'type' => 'upload',
                                'name' => 'imageleft',
                                'label' => __('Left Side Image', 'wp_dastak'),
                                'default' => '',
                            ),
                            array(
                                'type' => 'upload',
                                'name' => 'imageright',
                                'label' => __('Right Side Image', 'wp_dastak'),
                                'default' => '',
                            ),
                            array(
                                'type' => 'radiobutton',
                                'name' => 'color',
                                'label' => __('Mega Menu Color Scheme', 'wp_dastak'),
                                'items' => array(
                                    array(
                                        'value' => '',
                                        'label' => __('light', 'wp_dastak'),
                                    ),
                                    array(
                                        'value' => 'dark',
                                        'label' => __('Dark', 'wp_dastak'),
                                    ),
                                ),
                                'default' => array(
                                    '',
                                ),
                            ),
                            array(
                                'type' => 'textbox',
                                'name' => 'shortcode',
                                'label' => __('Shortcode', 'wp_dastak'),
                                'description' => __('Shortcode', 'wp_dastak'),
                                'binding' => array(
                                    'field' => 'style,position,imageleft,imageright,color',
                                    'function' => 'vp_megamenu_container_shortcode'
                                )
                            ),
                        ),
),
),
),
array(
    'title' => __('Custom Menu Settings', 'wp_dastak'),
    'name' => 'custom_menu_settings',
    'icon' => 'font-awesome:fa fa-minus',
    'controls' => array(
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Custom Menu Section', 'wp_dastak'),
            'name' => 'custom_menu_section',
            'description' => __('This section is used for custom menu section settings', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'title',
                    'label' => __('Custom Menu Title', 'wp_dastak'),
                    'description' => __('Enter the title for custom menu section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'select',
                    'name' => 'cols',
                    'label' => __('Grid Type', 'wp_dastak'),
                    'description' => __('Choose grid type of this shortcode', 'wp_dastak'),
                    'items' => array(array('value' => '6', 'label' => 'Grid 1/2'), array('value' => '4', 'label' => 'Grid 1/3'), array('value' => '3', 'label' => 'Grid 1/4')),
                    'default' => '3'
                ),
                array(
                    'type' => 'select',
                    'name' => 'menu',
                    'label' => __('Custom Menu', 'wp_dastak'),
                    'description' => __('Select custom menu to buid shortcode for mega menu', 'wp_dastak'),
                    'items' => sh_get_nav_menues(),
                    'default' => ''
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'custom_menu_shortcode',
                    'label' => __('Custom Menu Shortcode', 'wp_dastak'),
                    'description' => __('Use this shortcode in menu description field to display custom menu in mega menu section', 'wp_dastak'),
                    'binding' => array(
                        'field' => 'title,menu,cols',
                        'function' => 'vp_custom_menu_shortcode'
                    )
                ),
            ),
        ),
    ),
),
array(
    'title' => __('Custom Carousel Settings', 'wp_dastak'),
    'name' => 'custom_carousel_settings',
    'icon' => 'font-awesome:fa fa-minus',
    'controls' => array(
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Custom Carousel Section', 'wp_dastak'),
            'name' => 'custom_carousel_section',
            'description' => __('This section is used for custom carousel shortcode settings', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'title',
                    'label' => __('Custom Carousel Title', 'wp_dastak'),
                    'description' => __('Enter the title for custom carousel section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'select',
                    'name' => 'post_type',
                    'label' => __('Post Type', 'wp_dastak'),
                    'description' => __('Choose the post type which you want to show the articles in mega menu shortcode', 'wp_dastak'),
                    'items' => array(array('value' => 'post', 'label' => 'Post'), array('value' => 'sh_service', 'label' => 'Services'), array('value' => 'sh_team', 'label' => 'Team Members'), array('value' => 'sh_portfolio', 'label' => 'Portfolios'), array('value' => 'sh_project', 'label' => 'Projects'), array('value' => 'sh_event', 'label' => 'Events'), array('value' => 'sh_job', 'label' => 'Jobs'), array('value' => 'product', 'label' => 'Products')),
                    'default' => ''
                ),
                array(
                    'type' => 'select',
                    'name' => 'cols',
                    'label' => __('Grid Type', 'wp_dastak'),
                    'description' => __('Choose grid type of this shortcode', 'wp_dastak'),
                    'items' => array(array('value' => '6', 'label' => 'Grid 1/2'), array('value' => '4', 'label' => 'Grid 1/3'), array('value' => '3', 'label' => 'Grid 1/4')),
                    'default' => '3'
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'num',
                    'label' => __('No of Posts', 'wp_dastak'),
                    'description' => __('Enter the number of post for custom carousel section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'custom_carousel_shortcode',
                    'label' => __('Custom Carousel Shortcode', 'wp_dastak'),
                    'description' => __('Use this shortcode in menu description field to display custom menu in mega menu section', 'wp_dastak'),
                    'binding' => array(
                        'field' => 'title,post_type,cols,num',
                        'function' => 'vp_custom_carousel_shortcode'
                    )
                ),
            ),
        ),
    ),
),
array(
    'title' => __('Custom Content Settings', 'wp_dastak'),
    'name' => 'custom_content_settings',
    'icon' => 'font-awesome:fa fa-minus',
    'controls' => array(
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Custom Content Section', 'wp_dastak'),
            'name' => 'custom_content_section',
            'description' => __('This section is used for custom content section settings', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'title',
                    'label' => __('Custom Content Title', 'wp_dastak'),
                    'description' => __('Enter the title for custom content section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'textarea',
                    'name' => 'description',
                    'label' => __('Custom Content Description', 'wp_dastak'),
                    'description' => __('Enter the description for custom content section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'select',
                    'name' => 'cols',
                    'label' => __('Grid Type', 'wp_dastak'),
                    'description' => __('Choose grid type of this shortcode', 'wp_dastak'),
                    'items' => array(array('value' => '6', 'label' => 'Grid 1/2'), array('value' => '4', 'label' => 'Grid 1/3'), array('value' => '3', 'label' => 'Grid 1/4')),
                    'default' => '3'
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'label',
                    'label' => __('Button Label', 'wp_dastak'),
                    'description' => __('Enter the button label for custom content section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'url',
                    'label' => __('Button URL', 'wp_dastak'),
                    'description' => __('Enter the button url for custom content section to show on mega menu', 'wp_dastak'),
                    'default' => ''
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'custom_content_shortcode',
                    'label' => __('Custom Content Shortcode', 'wp_dastak'),
                    'description' => __('Use this shortcode in menu description field to display custom menu in mega menu section', 'wp_dastak'),
                    'binding' => array(
                        'field' => 'title,description,cols,label,url',
                        'function' => 'vp_custom_content_shortcode'
                    )
                ),
            ),
        ),
    ),
),
),
),
/** Under Construction Settings */
array(
    'title' => __('Under Construction', 'wp_dastak'),
    'name' => 'under_construction_settings',
    'icon' => 'font-awesome:fa fa-wrench',
    'controls' => array(
        array(
            'name' => 'under_const_status',
            'label' => 'Enable Under Construction Mode',
            'type' => 'toggle',
            'default' => 0,
        ),
        array(
            'type' => 'section',
            'title' => __('Under Construction Page Settings', 'wp_dastak'),
            'name' => 'h1_settings',
            'description' => __('heading 1 font settings', 'wp_dastak'),
            'dependency' => array(
                'field' => 'under_const_status',
                'function' => 'vp_dep_boolean',
            ),
            'fields' => array(
                array(
                    'type' => 'date',
                    'name' => 'launch_date',
                    'label' => __('Date', 'wp_dastak'),
                    'description' => __('Choose the Launching Date.', 'wp_dastak'),
                    'format' => 'yy-mm-dd',
                    'default' => '',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'under_const_welcome_title',
                    'label' => __('Welcome Title', 'wp_dastak'),
                    'description' => __('Enter the Welcome Title to show on under construction page.', 'wp_dastak'),
                    'default' => 'Coming Soon',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'under_const_welcome_text',
                    'label' => __('Welcome Text', 'wp_dastak'),
                    'description' => __('Enter the Welcome Text to show on under construction page.', 'wp_dastak'),
                    'default' => 'We are under construction and almost ready!',
                ),
            )
        ),
        array(
            'name' => 'under_const_subscribe_form',
            'label' => 'Enable Under Construction Subscription Form',
            'type' => 'toggle',
            'default' => 0,
        ),
        array(
            'type' => 'section',
            'title' => __('Under Construction Subscription form Settings', 'wp_dastak'),
            'name' => 'subsribe_form',
            'description' => __('Subscribe form settings', 'wp_dastak'),
            'dependency' => array(
                'field' => 'under_const_subscribe_form',
                'function' => 'vp_dep_boolean',
            ),
            'fields' => array(
                array(
                    'type' => 'textbox',
                    'name' => 'under_const_subscribe_id',
                    'label' => __('Feedburner ID', 'wp_dastak'),
                    'description' => __('Enter the Feedburner ID for subscribe form on under construction page.', 'wp_dastak'),
                    'default' => 'WANT TO KNOW WHEN WE ARE LAUNCHING?',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'under_const_subscribe_title',
                    'label' => __('Subscription Form Title', 'wp_dastak'),
                    'description' => __('Enter the subscription form title to show on under construction page.', 'wp_dastak'),
                    'default' => 'WANT TO KNOW WHEN WE ARE LAUNCHING?',
                ),
                array(
                    'type' => 'textbox',
                    'name' => 'under_const_subscribe_text',
                    'label' => __('Subscription Form Text', 'wp_dastak'),
                    'description' => __('Enter the subscription form text to show on under construction page.', 'wp_dastak'),
                    'default' => 'Subscribe to entering you email below:',
                ),
            )
        ),
        array(
            'type' => 'builder',
            'repeating' => true,
            'sortable' => true,
            'label' => __('Coming Soon Slider', 'wp_dastak'),
            'name' => 'coming_soon',
            'description' => __('This section is used for under construction page slider', 'wp_dastak'),
            'fields' => array(
                array(
                    'type' => 'upload',
                    'name' => 'slide',
                    'label' => __('Slide', 'wp_dastak'),
                    'description' => __('Insert slide image', 'wp_dastak'),
                    'default' => '',
                )
            ),
        ),
    )
),
        // Dynamic Social Media Creator
//        array(
//            'title' => __('Auto Update', 'wp_dastak'),
//            'name' => 'sh_auto_update',
//            'icon' => 'font-awesome:fa fa-cogs',
//            'controls' => array(
//                array(
//                    'type' => 'textbox',
//                    'name' => 'purchase_code',
//                    'label' => __('Purchase Code:', 'wp_dastak'),
//                    'description' => __('Enter Your Purchase Code.', 'wp_dastak'),
//                ),
//                array(
//                    'type' => 'toggle',
//                    'name' => 'xml_update_notifier',
//                    'label' => __('Update Notifier:', 'wp_dastak'),
//                    'description' => __('Show update notifier, when update is available.', 'wp_dastak'),
//                ),
//                array(
//                    'type' => 'select',
//                    'name' => 'update_xml_notifier',
//                    'label' => __('Select Hour:', 'wp_dastak'),
//                    'description' => __('Select the hour to perform automatic update ever selected hour.', 'wp_dastak'),
//                    'items' => array(
//                        'data' => array(
//                            array(
//                                'source' => 'function',
//                                'value' => 'sh_houre_range',
//                            ),
//                        ),
//                    ),
//                    'default' => array(
//                        '{{first}}',
//                    ),
//                    'dependency' => array(
//                        'field' => 'xml_update_notifier',
//                        'function' => 'vp_dep_boolean',
//                    ),
//                ),
//                array(
//                    'type' => 'toggle',
//                    'name' => 'update_notice',
//                    'label' => __('Show Update Bar:', 'wp_dastak'),
//                    'description' => __('Show or hide update bar.', 'wp_dastak'),
//                ),
//                array(
//                    'type' => 'notebox',
//                    'name' => 'notebox_backup',
//                    'label' => __('Note:', 'wp_dastak'),
//                    'description' => __('This section is use to Enable/Disable to create backup and delete old backup before theme update process each time.', 'wp_dastak'),
//                    'status' => 'info',
//                ),
//                array(
//                    'type' => 'toggle',
//                    'name' => 'create_backup',
//                    'label' => __('Backup:', 'wp_dastak'),
//                    'description' => __('Create backup or not before update.', 'wp_dastak'),
//                ),
//                array(
//                    'type' => 'toggle',
//                    'name' => 'delete_old_backup',
//                    'label' => __('Delete Backup:', 'wp_dastak'),
//                    'description' => __('Delete old backup files.', 'wp_dastak'),
//                ),
//                array(
//                    'type' => 'notebox',
//                    'name' => 'notebox',
//                    'label' => __('Note:', 'wp_dastak'),
//                    'description' => __('When you will update theme your all customization in the current theme will be lossed. So Please make sure you have enable backup option before update your theme.', 'wp_dastak'),
//                    'status' => 'info',
//                ),
//                array(
//                    'type' => 'button',
//                    'name' => 'update_button',
//                    'label' => __('Update Theme', 'wp_dastak'),
//                    'description' => __('Update your theme to latest version.', 'wp_dastak'),
//                ),
//            )
//        ),
/** Font settings */
array(
    'title' => __('Font Settings', 'wp_dastak'),
    'name' => 'font_settings',
    'icon' => 'font-awesome:fa fa-font',
    'menus' => array(
        /** heading font settings */
        array(
            'title' => __('Heading Font', 'wp_dastak'),
            'name' => 'heading_font_settings',
            'icon' => 'font-awesome:fa fa-text-height',
            'controls' => array(
                array(
                    'type' => 'toggle',
                    'name' => 'use_custom_font',
                    'label' => __('Use Custom Font', 'wp_dastak'),
                    'description' => __('Use custom font or not', 'wp_dastak'),
                ),
                array(
                    'type' => 'section',
                    'title' => __('H1 Settings', 'wp_dastak'),
                    'name' => 'h1_settings',
                    'description' => __('heading 1 font settings', 'wp_dastak'),
                    'fields' => array(
                        array(
                            'type' => 'html',
                            'name' => 'h1_font_preview',
                            'binding' => array(
                                'field' => 'h1_font_family,h1_font_color,h1_font_size',
                                'function' => 'vp_font_preview',
                            ),
                        ),
                        array(
                            'type' => 'select',
                            'label' => __('Font Family', 'wp_dastak'),
                            'name' => 'h1_font_family',
                            'description' => __('Select the font family to use for h1', 'wp_dastak'),
                            'items' => array(
                                'data' => array(
                                    array(
                                        'source' => 'function',
                                        'value' => 'vp_get_gwf_family',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'h1_font_color',
                            'label' => __('Font Color', 'wp_dastak'),
                            'description' => __('Choose the font color for heading h1', 'wp_dastak'),
                            'default' => '#98ed28',
                        ),
                        array(
                            'type' => 'slider',
                            'name' => 'h1_font_size',
                            'label' => __('H1 Font Size (px)', 'wp_dastak'),
                            'description' => __('Choose the font size for heading h1', 'wp_dastak'),
                            'min' => '5',
                            'max' => '32',
                            'default' => '16',
                        ),
                    ),
                ),
                array(
                    'type' => 'section',
                    'title' => __('H2 Settings', 'wp_dastak'),
                    'name' => 'h2_settings',
                    'description' => __('heading 2 font settings', 'wp_dastak'),
                    'fields' => array(
                        array(
                            'type' => 'html',
                            'name' => 'h2_font_preview',
                            'binding' => array(
                                'field' => 'h2_font_family,h2_font_color,h2_font_size',
                                'function' => 'vp_font_preview',
                            ),
                        ),
                        array(
                            'type' => 'select',
                            'label' => __('Font Family', 'wp_dastak'),
                            'name' => 'h2_font_family',
                            'description' => __('Select the font family to use for h2', 'wp_dastak'),
                            'items' => array(
                                'data' => array(
                                    array(
                                        'source' => 'function',
                                        'value' => 'vp_get_gwf_family',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'h2_font_color',
                            'label' => __('Font Color', 'wp_dastak'),
                            'description' => __('Choose the font color for heading h2', 'wp_dastak'),
                            'default' => '#98ed28',
                        ),
                        array(
                            'type' => 'slider',
                            'name' => 'h2_font_size',
                            'label' => __('H2 Font Size (px)', 'wp_dastak'),
                            'description' => __('Choose the font size for heading h2', 'wp_dastak'),
                            'min' => '5',
                            'max' => '32',
                            'default' => '16',
                        ),
                    ),
                ),
                array(
                    'type' => 'section',
                    'title' => __('H3 Settings', 'wp_dastak'),
                    'name' => 'h3_settings',
                    'description' => __('heading 3 font settings', 'wp_dastak'),
                    'fields' => array(
                        array(
                            'type' => 'html',
                            'name' => 'h3_font_preview',
                            'binding' => array(
                                'field' => 'h3_font_family,h3_font_color,h3_font_size',
                                'function' => 'vp_font_preview',
                            ),
                        ),
                        array(
                            'type' => 'select',
                            'label' => __('Font Family', 'wp_dastak'),
                            'name' => 'h3_font_family',
                            'description' => __('Select the font family to use for h3', 'wp_dastak'),
                            'items' => array(
                                'data' => array(
                                    array(
                                        'source' => 'function',
                                        'value' => 'vp_get_gwf_family',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'h3_font_color',
                            'label' => __('Font Color', 'wp_dastak'),
                            'description' => __('Choose the font color for heading h3', 'wp_dastak'),
                            'default' => '#98ed28',
                        ),
                        array(
                            'type' => 'slider',
                            'name' => 'h3_font_size',
                            'label' => __('H3 Font Size (px)', 'wp_dastak'),
                            'description' => __('Choose the font size for heading h3', 'wp_dastak'),
                            'min' => '5',
                            'max' => '32',
                            'default' => '16',
                        ),
                    ),
                ),
                array(
                    'type' => 'section',
                    'title' => __('H4 Settings', 'wp_dastak'),
                    'name' => 'h4_settings',
                    'description' => __('heading 4 font settings', 'wp_dastak'),
                    'fields' => array(
                        array(
                            'type' => 'html',
                            'name' => 'h4_font_preview',
                            'binding' => array(
                                'field' => 'h4_font_family,h4_font_color,h4_font_size',
                                'function' => 'vp_font_preview',
                            ),
                        ),
                        array(
                            'type' => 'select',
                            'label' => __('Font Family', 'wp_dastak'),
                            'name' => 'h4_font_family',
                            'description' => __('Select the font family to use for h4', 'wp_dastak'),
                            'items' => array(
                                'data' => array(
                                    array(
                                        'source' => 'function',
                                        'value' => 'vp_get_gwf_family',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'h4_font_color',
                            'label' => __('Font Color', 'wp_dastak'),
                            'description' => __('Choose the font color for heading h4', 'wp_dastak'),
                            'default' => '#98ed28',
                        ),
                        array(
                            'type' => 'slider',
                            'name' => 'h4_font_size',
                            'label' => __('H4 Font Size (px)', 'wp_dastak'),
                            'description' => __('Choose the font size for heading h4', 'wp_dastak'),
                            'min' => '5',
                            'max' => '32',
                            'default' => '16',
                        ),
                    ),
                ),
                array(
                    'type' => 'section',
                    'title' => __('H5 Settings', 'wp_dastak'),
                    'name' => 'h5_settings',
                    'description' => __('heading 5 font settings', 'wp_dastak'),
                    'fields' => array(
                        array(
                            'type' => 'html',
                            'name' => 'h5_font_preview',
                            'binding' => array(
                                'field' => 'h5_font_family,h5_font_color,h5_font_size',
                                'function' => 'vp_font_preview',
                            ),
                        ),
                        array(
                            'type' => 'select',
                            'label' => __('Font Family', 'wp_dastak'),
                            'name' => 'h5_font_family',
                            'description' => __('Select the font family to use for h5', 'wp_dastak'),
                            'items' => array(
                                'data' => array(
                                    array(
                                        'source' => 'function',
                                        'value' => 'vp_get_gwf_family',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'h5_font_color',
                            'label' => __('Font Color', 'wp_dastak'),
                            'description' => __('Choose the font color for heading h5', 'wp_dastak'),
                            'default' => '#98ed28',
                        ),
                        array(
                            'type' => 'slider',
                            'name' => 'h5_font_size',
                            'label' => __('H5 Font Size (px)', 'wp_dastak'),
                            'description' => __('Choose the font size for heading h5', 'wp_dastak'),
                            'min' => '5',
                            'max' => '32',
                            'default' => '16',
                        ),
                    ),
                ),
                array(
                    'type' => 'section',
                    'title' => __('H6 Settings', 'wp_dastak'),
                    'name' => 'h6_settings',
                    'description' => __('Heading 6 font settings', 'wp_dastak'),
                    'fields' => array(
                        array(
                            'type' => 'html',
                            'name' => 'h6_font_preview',
                            'binding' => array(
                                'field' => 'h6_font_family,h6_font_color,h6_font_size',
                                'function' => 'vp_font_preview',
                            ),
                        ),
                        array(
                            'type' => 'select',
                            'label' => __('Font Family', 'wp_dastak'),
                            'name' => 'h6_font_family',
                            'description' => __('Select the font family to use for h6', 'wp_dastak'),
                            'items' => array(
                                'data' => array(
                                    array(
                                        'source' => 'function',
                                        'value' => 'vp_get_gwf_family',
                                    ),
                                ),
                            ),
                        ),
                        array(
                            'type' => 'color',
                            'name' => 'h6_font_color',
                            'label' => __('Font Color', 'wp_dastak'),
                            'description' => __('Choose the font color for heading h6', 'wp_dastak'),
                            'default' => '#98ed28',
                        ),
                        array(
                            'type' => 'slider',
                            'name' => 'h6_font_size',
                            'label' => __('H6 Font Size (px)', 'wp_dastak'),
                            'description' => __('Choose the font size for heading h6', 'wp_dastak'),
                            'min' => '5',
                            'max' => '32',
                            'default' => '16',
                        ),
                    ),
                ),
            )
),
/** body font settings */
array(
    'title' => __('Body Font', 'wp_dastak'),
    'name' => 'body_font_settings',
    'icon' => 'font-awesome:fa fa-text-height',
    'controls' => array(
        array(
            'type' => 'toggle',
            'name' => 'body_custom_font',
            'label' => __('Use Custom Font', 'wp_dastak'),
            'description' => __('Use custom font or not', 'wp_dastak'),
        ),
        array(
            'type' => 'select',
            'label' => __('Font Family', 'wp_dastak'),
            'name' => 'body_font_family',
            'description' => __('Select the font family to use for body', 'wp_dastak'),
            'items' => array(
                'data' => array(
                    array(
                        'source' => 'function',
                        'value' => 'vp_get_gwf_family',
                    ),
                ),
            ),
        ),
        array(
            'type' => 'color',
            'name' => 'body_font_color',
            'label' => __('Font Color', 'wp_dastak'),
            'description' => __('Choose the font color for heading body', 'wp_dastak'),
            'default' => '#98ed28',
        ),
        array(
            'type' => 'slider',
            'name' => 'body_font_size',
            'label' => __('Body Font Size (px)', 'wp_electric'),
            'description' => __('Choose the font size for heading body', 'wp_dastak'),
            'min' => '5',
            'max' => '32',
            'default' => '16',
        ),
    )
),
/** body font settings */
/* 	array() */
)
),
)
);



/**
 *EOF
 */