<?php

$vc_array[] = array(
	"name" => __( "Portfolio Listing", 'wp_dastak' ),
	"base" => "sh_portfolio_listing",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/single-portfolio.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of portfolios to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '4' => __( 'Three Columns', 'wp_dastak' ), '3' => __( 'Four Columns', 'wp_dastak' ), '6' => __( 'Two Columns', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'portfolio_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Categories.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Show Tabs", 'wp_dastak' ),
			"param_name" => "tabs",
			"value" => array( 'Enable Tabs' => true ),
			"description" => __( "Enable to show categories tabs on portfolio listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Modern Portfolios", 'wp_dastak' ),
	"base" => "sh_portfolio",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/modern-portfolios.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'portfolio_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Portfolios Masonary", 'wp_dastak' ),
	"base" => "sh_portfolios_masonary",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/portfolios-masonary.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of portfolios to show", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( array_merge( (array) sh_get_categories( array( 'taxonomy' => 'portfolio_category', 'hide_empty' => FALSE ) ) ) ),
			"description" => __( 'Choose Categories.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Show Tabs", 'wp_dastak' ),
			"param_name" => "tabs",
			"value" => array( 'Enable Tabs' => true ),
			"description" => __( "Enable to show categories tabs on portfolio listing", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Traditional Portfolios", 'wp_dastak' ),
	"base" => "sh_portfolio_2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/traditional-portfolios.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of portfolios to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "No. Of Columns", 'wp_dastak' ),
			"param_name" => "col",
			'value' => array( __( 'Two Columns', 'wp_dastak' ) => 2, __( 'Four Columns', 'wp_dastak' ) => 4, __( 'Random', 'wp_dastak' ) => 'random' ),
			"description" => __( "Choose columns .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Portfolio Style", 'wp_dastak' ),
			"param_name" => "style",
			"value" => array( 'Traditional Style One' => '1', 'Traditional Style Two' => '2', 'Traditional Style Three' => '3' ),
			"description" => __( "Choose style for portfolios listing", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'portfolio_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Categories.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "orderby",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Show Tabs", 'wp_dastak' ),
			"param_name" => "tabs",
			"value" => array( 'Enable Tabs' => true ),
			"description" => __( "Enable to show categories tabs on portfolio listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Projects Carousel", 'wp_dastak' ),
	"base" => "sh_portfolio_3",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/projects-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "orderby",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( array_merge( array( '' => __( 'All Categories', 'wp_dastak' ) ), (array) sh_get_categories( array( 'taxonomy' => 'project_category', 'hide_empty' => FALSE ) ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		)
	)
);

$vc_array[] = array(
	"name" => __( "Projects Listing", 'wp_dastak' ),
	"base" => "sh_projects_listing",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Project-Listing.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of projects to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '4' => __( 'Three Columns', 'wp_dastak' ), '3' => __( 'Four Columns', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( array_merge( (array) sh_get_categories( array( 'taxonomy' => 'project_category', 'hide_empty' => FALSE ) ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Contact Form", 'wp_dastak' ),
	"base" => "sh_contact_form",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Contact-Form.png',
	"params" => array(
		array(
			"type" => "textarea_html",
			
			"class" => "",
			"heading" => __( 'Description', 'wp_dastak' ),
			"param_name" => "content",
			"value" => '',
			"description" => __( 'Enter the content.', 'wp_dastak' )
		),
		array(
			"type" => "textarea_raw_html",
			
			"class" => "",
			"heading" => __( 'Google Map', 'wp_dastak' ),
			"param_name" => "map",
			"value" => '',
			"description" => __( 'Enter the google map iframe', 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Email", 'wp_dastak' ),
			"param_name" => "email",
			'value' => '',
			"description" => __( "Enter the valid email to show.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( 'Phone', 'wp_dastak' ),
			"param_name" => "phone",
			"value" => '',
			"description" => __( 'Enter phone.', 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( 'Address', 'wp_dastak' ),
			"param_name" => "address",
			"value" => '',
			"description" => __( 'Enter Address.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Modern Contact Form", 'wp_dastak' ),
	"base" => "sh_contact_form2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/modern-contact-form.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for contact form", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( 'Description', 'wp_dastak' ),
			"param_name" => "content",
			"value" => '',
			"description" => __( 'Enter the content.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the contact form background image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "LayerSlider With Contact Form", 'wp_dastak' ),
	"base" => "sh_slider_form",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/revolution-slider-with-contact-form.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for contact form", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( 'Description', 'wp_dastak' ),
			"param_name" => "content",
			"value" => '',
			"description" => __( 'Enter the content.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Slider", 'wp_dastak' ),
			"param_name" => "slider",
			"value" => array_flip( sh_get_layer_sliders() ),
			"description" => __( "Select slider to show", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the contact form background image", 'wp_dastak' )
		),
	)
);
if ( function_exists( 'get_new_royalslider' ) ) {
	$vc_array[] = array(
		"name" => __( "Dastak RoyalSlider", 'wp_dastak' ),
		"base" => "sh_royalslider",
		"class" => "",
		"category" => __( 'Dastak', 'wp_dastak' ),
		"icon" => get_template_directory_uri() . '/images/icon/Appointment-Form.png',
		"params" => array(
			array(
				"type" => "dropdown",
				
				"class" => "",
				"heading" => __( "Select Slider", 'wp_dastak' ),
				"param_name" => "slider",
				"value" => array_flip( sh_get_royal_slider() ),
				"description" => __( "Select royalslider to show", 'wp_dastak' )
			),
		)
	);
}

$vc_array[] = array(
	"name" => __( "Appointment Form", 'wp_dastak' ),
	"base" => "sh_appointment_form",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Appointment-Form.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for contact form", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Get A Quote Form", 'wp_dastak' ),
	"base" => "sh_get_quote_form",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/get-a-quote-form.png',
	"params" => array(
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Contact Us Style 1", 'wp_dastak' ),
	"base" => "sh_get_in_touch",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/contact-us-style.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for contact form", 'wp_dastak' )
		),
                array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Reciever Email", 'wp_dastak' ),
			"param_name" => "to_email",
			"description" => __( "Enter the email address of receiver to send the form submission detail.", 'wp_dastak' )
		),
                array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Subject Of Incoming Mail", 'wp_dastak' ),
			"param_name" => "mail_subject",
			"description" => __( "Enter the subject of incoming mail.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Dastak Forms", 'wp_dastak' ),
	"base" => "sh_dastak_forms",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/dastak-forms.png',
	"params" => array(
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "FAQ's Accordion", 'wp_dastak' ),
	"base" => "sh_faqs",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/faqs-accordion.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( array_merge( (array) sh_get_categories( array( 'taxonomy' => 'faq_category', 'hide_empty' => FALSE ), true ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "orderby",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Email Subscription Form", 'wp_dastak' ),
	"base" => "sh_newsletter_form",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/email-subscription-form.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			'value' => __( 'Subscribe for Newsletter', 'wp_dastak' ),
			"description" => __( "Enter the title of the form, Leave empty if you don't want to show title", 'wp_dastak' )
		),
		array(
            'type'              => 'dropdown',
            'class'             => '',
            'heading'           => esc_html__( 'Select Subscription Form Type', 'dastak' ),
            'param_name'        => 'form_type',
            'value'             => array( 
            	esc_html__( 'Feedburner Form', 'dastak' ) => 'feedburner', 
            	esc_html__( 'Mailchimp Form', 'dastak' ) => 'mailchimp' ),
            'description'       => esc_html__( 'Select subscription form type that you wants to use.', 'dastak' )
        ),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => __( "Feedburner ID", 'dastak' ),
			"param_name" => "id",
			'value' => 'genuine',
			"description" => __( "Enter the google feedburner id", 'wp_dastak' ),
			'dependency'    => array(
				'element'   => 'form_type',
				'value'     =>  'feedburner',
			),
		),
		array(
			'type'              => 'dropdown',
			'class'             => '',
			'heading'           => esc_html__( 'Mailchimp Lists', 'dastak' ),
			'param_name'        => 'newsltr_mc_lists',
			'admin_label'       => true,
			'value'             => array_flip( dastak_get_mc_lists() ),
			'description'       => esc_html__( 'Choose the mailchimp lists to subscribe the user. For more settings use Mailchimp for WP plugin settings.', 'dastak' ),
			'dependency'    => array(
				'element'   => 'form_type',
				'value'     =>  'mailchimp',
			),
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Text", 'wp_dastak' ),
			"param_name" => "button_text",
			'value' => '',
			"description" => __( "Enter the button text", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Newsletter Subscription Short Box", 'wp_dastak' ),
	"base" => "sh_newsletter_form2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/newsletter-subscription.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			'value' => __( 'Newsletter', 'wp_dastak' ),
			"description" => __( "Enter the sub title of the form, Leave empty if you don't want to show title", 'wp_dastak' )
		),
		array(
            'type'              => 'dropdown',
            'class'             => '',
            'heading'           => esc_html__( 'Select Subscription Form Type', 'dastak' ),
            'param_name'        => 'form_type',
            'value'             => array( 
            	esc_html__( 'Feedburner Form', 'dastak' ) => 'feedburner', 
            	esc_html__( 'Mailchimp Form', 'dastak' ) => 'mailchimp' ),
            'description'       => esc_html__( 'Select subscription form type that you wants to use.', 'dastak' )
        ),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => __( "Feedburner ID", 'dastak' ),
			"param_name" => "id",
			'value' => 'genuine',
			"description" => __( "Enter the google feedburner id", 'wp_dastak' ),
			'dependency'    => array(
				'element'   => 'form_type',
				'value'     =>  'feedburner',
			),
		),
		array(
			'type'              => 'dropdown',
			'class'             => '',
			'heading'           => esc_html__( 'Mailchimp Lists', 'dastak' ),
			'param_name'        => 'newsltr_mc_lists',
			'admin_label'       => true,
			'value'             => array_flip( dastak_get_mc_lists() ),
			'description'       => esc_html__( 'Choose the mailchimp lists to subscribe the user. For more settings use Mailchimp for WP plugin settings.', 'dastak' ),
			'dependency'    => array(
				'element'   => 'form_type',
				'value'     =>  'mailchimp',
			),
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => __( "Button Text", 'wp_dastak' ),
			"param_name" => "button_text",
			'value' => '',
			"description" => __( "Enter the button text", 'wp_dastak' )
		),
	)
);


/** Social profile with icons */
//Register "container" content element. It will hold all your inner (child) content elements
$vc_array[] = array(
	"name" => __( "Social Profile", 'wp_dastak' ),
	"base" => "sh_social_profile",
	"as_parent" => array( 'only' => 'sh_profile_icon' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"show_settings_on_create" => false,
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'wp_dastak' )
		)
	),
	"js_view" => 'VcColumnView'
);

$vc_array[] = array(
	"name" => __( "Social Profile Icon", 'wp_dastak' ),
	"base" => "sh_profile_icon",
	"content_element" => true,
	"as_child" => array( 'only' => 'sh_social_profile' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for social profile", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Link", 'wp_dastak' ),
			"param_name" => "link",
			"description" => __( "Enter the link to your social profile", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			"heading" => __( "Social Icon", 'wp_dastak' ),
			"param_name" => "icon",
			'value' => array_flip( array( 'bitbucket' => 'Bitbucket', 'dribble' => 'Dribble', 'facebook' => 'Facebook', 'flickr' => 'Flickr', 'github' => 'Github', 'google-plus' => 'Google Plus',
				'instagram' => 'Instagram', 'linkedin' => 'LinkedIn', 'pinterest' => 'Pinterest', 'skype' => 'Skype', 'stack-overflow' => 'Stack Overflow', 'tumblr' => 'Tumblr',
				'twitter' => 'Twitter', 'vimeo' => 'Vimeo', 'vk' => 'VK', 'weibo' => 'Weibo', 'windows' => 'Windows', 'xing' => 'Xing', 'youtube' => 'Youtube' ) ),
			"description" => __( "Choose the social profile icon", 'wp_dastak' )
		)
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_Sh_Social_Profile extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Profile_Icon extends WPBakeryShortCode {

}

class WPBakeryShortCode_Sh_Fun_Facts extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Fact extends WPBakeryShortCode {

}

/** fun facts with icons */
//Register "container" content element. It will hold all your inner (child) content elements
$vc_array[] = array(
	"name" => __( "Fun Facts Parallax", 'wp_dastak' ),
	"base" => "sh_fun_facts",
	"as_parent" => array( 'only' => 'sh_fact' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"icon" => get_template_directory_uri() . '/images/icon/fun-facts-parallax.png',
	"category" => "Dastak",
	"show_settings_on_create" => false,
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the image", 'wp_dastak' )
		),
	),
	"js_view" => 'VcColumnView'
);
$vc_array[] = array(
	"name" => __( "Fact", 'wp_dastak' ),
	"base" => "sh_fact",
	"content_element" => true,
	"category" => "Dastak",
	"as_child" => array( 'only' => 'sh_fun_facts' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for fact", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Value", 'wp_dastak' ),
			"param_name" => "value",
			"description" => __( "Enter the value for the fact", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			"heading" => __( "Icons", 'wp_dastak' ),
			"param_name" => "icon",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose the icon for fun fact", 'wp_dastak' )
		)
	)
);


$vc_array[] = array(
	"name" => __( "Featured Images Tabs Carousel With Parallax", 'wp_dastak' ),
	"base" => "sh_parallax_images_carousel",
	"icon" => get_template_directory_uri() . '/images/icon/fun-facts-parallax.png',
	"category" => "Dastak",
	"params" => array(
		array(
			"type" => "attach_images",
			
			"class" => "",
			"heading" => __( "Slide Images", 'wp_dastak' ),
			"param_name" => "thumbs",
			"value" => '',
			"description" => __( "upload thumb images for parallax left section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image", 'wp_dastak' )
		),
	),
	"js_view" => 'VcColumnView'
);

$vc_array[] = array(
	"name" => __( "Our Blog", 'wp_dastak' ),
	"base" => "sh_our_blog",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/our-blog.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of Posts to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of Posts .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random', 'Comments Count' => 'comment_count' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Blog List(Small Thumb)", 'wp_dastak' ),
	"base" => "sh_our_blog_two",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/blog-list-small-thumb.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of Posts to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of Posts .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random', 'Comments Count' => 'comment_count' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Blog List Detailed", 'wp_dastak' ),
	"base" => "sh_our_blog_three",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/blog-list-detailed.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of Posts to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of columns", 'wp_dastak' ),
			"param_name" => "cols",
			"value" => array( 'Two Columns' => '6', 'Three Columns' => '4', 'Four Columns' => '3' ),
			"description" => __( "Choose the number post columns to show in blog carousel", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of Posts .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random', 'Comments Count' => 'comment_count' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Blog Carousel", 'wp_dastak' ),
	"base" => "sh_blog_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/blog-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of Posts to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of Posts .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random', 'Comments Count' => 'comment_count' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of columns", 'wp_dastak' ),
			"param_name" => "cols",
			"value" => array( 'Two Columns' => '2', 'Three Columns' => '3', 'Four Columns' => '4' ),
			"description" => __( "Choose the number post columns to show in blog carousel", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Download Banner", 'wp_dastak' ),
	"base" => "sh_download_banner",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/download-banner.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for banner", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the label for button.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Banner Icon", 'wp_dastak' ),
			"param_name" => "icon",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Content Box Textual With Slide", 'wp_dastak' ),
	"base" => "sh_conten_box",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/content-box-textual-with-slide.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter sub title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "attach_images",
			
			"class" => "",
			"heading" => __( "slides", 'wp_dastak' ),
			"param_name" => "slides",
			"value" => '',
			"description" => __( "Insert the slides images", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Simple Text Parallax", 'wp_dastak' ),
	"base" => "sh_conten_box2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Simple-Text-Parallax.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter sub title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the image", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Fancy Parallax", 'wp_dastak' ),
	"base" => "sh_fancy_parallax",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Simple-Text-Parallax.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title One", 'wp_dastak' ),
			"param_name" => "title1",
			"description" => __( "Enter title for parallax one", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description One", 'wp_dastak' ),
			"param_name" => "description1",
			"description" => __( "Enter the description for parallax one", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button One URL", 'wp_dastak' ),
			"param_name" => "url1",
			"description" => __( "Enter the URL for parallax button one", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image One", 'wp_dastak' ),
			"param_name" => "image1",
			"value" => '',
			"description" => __( "Upload background image for parallax one", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title Two", 'wp_dastak' ),
			"param_name" => "title2",
			"description" => __( "Enter title for parallax two", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description Two", 'wp_dastak' ),
			"param_name" => "description2",
			"description" => __( "Enter the description for parallax two", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Two URL", 'wp_dastak' ),
			"param_name" => "url2",
			"description" => __( "Enter the URL for parallax button two", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image Two", 'wp_dastak' ),
			"param_name" => "image2",
			"value" => '',
			"description" => __( "Upload background image for parallax two", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title Three", 'wp_dastak' ),
			"param_name" => "title3",
			"description" => __( "Enter title for parallax three", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description Three", 'wp_dastak' ),
			"param_name" => "description3",
			"description" => __( "Enter the description for parallax three", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Three URL", 'wp_dastak' ),
			"param_name" => "url3",
			"description" => __( "Enter the URL for parallax button three", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image Three", 'wp_dastak' ),
			"param_name" => "image3",
			"value" => '',
			"description" => __( "Upload background image for parallax three", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title Four", 'wp_dastak' ),
			"param_name" => "title4",
			"description" => __( "Enter title for parallax four", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description Four", 'wp_dastak' ),
			"param_name" => "description4",
			"description" => __( "Enter the description for parallax four", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Four URL", 'wp_dastak' ),
			"param_name" => "url4",
			"description" => __( "Enter the URL for parallax button four", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image Four", 'wp_dastak' ),
			"param_name" => "image4",
			"value" => '',
			"description" => __( "Upload background image for parallax four", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "About Us Content Box With Thumb", 'wp_dastak' ),
	"base" => "sh_conten_box3",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/about-us-content-box-with-thumb.png',
	"params" => array(
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the image", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Simple Content Box With Image", 'wp_dastak' ),
	"base" => "sh_conten_box4",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/simple-content-box-with-image.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the image", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Features Parallax Box For Intro", 'wp_dastak' ),
	"base" => "sh_content_box_parallax",
	"as_parent" => array( 'only' => 'sh_contents_list' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Features-Parallax-Box-For-Intro.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title One", 'wp_dastak' ),
			"param_name" => "title1",
			"description" => __( "Enter title one for content section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon One", 'wp_dastak' ),
			"param_name" => "icon1",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for title one", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title Two", 'wp_dastak' ),
			"param_name" => "title2",
			"description" => __( "Enter title two for content section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon Two", 'wp_dastak' ),
			"param_name" => "icon2",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for title two", 'wp_dastak' )
		),
		array(
			"type" => "textarea_html",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "bg",
			"value" => '',
			"description" => __( "Insert the background image", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Feature Item", 'wp_dastak' ),
	"base" => "sh_contents_list",
	"content_element" => true,
	"icon" => get_template_directory_uri() . '/images/icon/feature-item.png',
	"category" => __( 'Dastak', 'wp_dastak' ),
	"as_child" => array( 'only' => 'sh_content_box_parallax' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textarea",
			"heading" => __( "Content", 'wp_dastak' ),
			"param_name" => "content",
			"description" => __( "Add the list contents", 'wp_dastak' ),
			'value' => ''
		),
	)
);

$vc_array[] = array(
	"name" => __( "About Parallax With Video", 'wp_dastak' ),
	"base" => "sh_video_box",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/about-parallax-with-video.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter sub title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "textarea_html",
			
			"class" => "",
			"heading" => __( "Embed Video Code", 'wp_dastak' ),
			"param_name" => "content",
			"value" => '',
			"description" => __( "Enter the video embed code for this section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert the the background image", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Event Promotional Video", 'wp_dastak' ),
	"base" => "sh_promotional_video",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/event-promotional-video.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter sub title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "textarea_html",
			
			"class" => "",
			"heading" => __( "Video Url", 'wp_dastak' ),
			"param_name" => "content",
			"value" => '',
			"description" => __( "Enter the video embed code for this section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Location", 'wp_dastak' ),
			"param_name" => "location",
			"description" => __( "Enter the location for event.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Date", 'wp_dastak' ),
			"param_name" => "date",
			"description" => __( "Enter the date for event.", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Contact Box(click To Open)", 'wp_dastak' ),
	"base" => "sh_contact_box",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/contact-box.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter sub title for content section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Contact Number", 'wp_dastak' ),
			"param_name" => "phone",
			"description" => __( "Enter the contact number for contact section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the contents for this section", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert the the background image", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the the image for contact box", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable One", 'wp_dastak' ),
			"param_name" => "label1",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link One", 'wp_dastak' ),
			"param_name" => "url1",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Lable Two", 'wp_dastak' ),
			"param_name" => "label2",
			"description" => __( "Enter the button label.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Link Two", 'wp_dastak' ),
			"param_name" => "url2",
			"description" => __( "Enter the url for button.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services Accordion", 'wp_dastak' ),
	"base" => "sh_services_accordion",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-accordion.png',
	"params" => array(
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => __( "Accorion Style", 'wp_dastak' ),
			"param_name" => "style",
			"value" => array( 'Accordion Style One' => '1', 'Accordion Style Two' => '2', 'Accordion Style Three' => '3' ),
			"description" => __( "Choose accorion style for services listing", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",

			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services List", 'wp_dastak' ),
	"base" => "sh_services_list",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-accordion.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Services Modern With Parallax", 'wp_dastak' ),
	"base" => "sh_services_2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-modern-with-parallax.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of services to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert services background image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services With Circular Thumb", 'wp_dastak' ),
	"base" => "sh_services_3",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Services-With-Circular-Thumb.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '6' => __( 'Two Columns', 'wp_dastak' ), '4' => __( 'Three Columns', 'wp_dastak' ), '3' => __( 'Four Columns', 'wp_dastak' ) ) ),
			"description" => __( "Select number of columns to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services with Parallax", 'wp_dastak' ),
	"base" => "sh_services_4",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-with-parallax.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'Colored' => 'color', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert services background image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services Parallax with Company Intro", 'wp_dastak' ),
	"base" => "sh_services_5",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-parallax-with-company-intro.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for Services section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert services background image", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Featured Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert services featured image", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services With Round Icons", 'wp_dastak' ),
	"base" => "sh_services_6",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-with-round-icons.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '4' => __( 'Three Columns', 'wp_dastak' ), '6' => __( 'Two Columns', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Services With Carousel", 'wp_dastak' ),
	"base" => "sh_services_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-with-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for Services section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "bg",
			"value" => '',
			"description" => __( "Insert services background image", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of services listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services With Image and Icon", 'wp_dastak' ),
	"base" => "sh_services_with_image_icon",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/services-with-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of services to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '4' => __( 'Three Columns', 'wp_dastak' ), '3' => __( 'Four Columns', 'wp_dastak' ) ) ),
			"description" => __( "Select number of columns to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of services listing", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "About Us Carousel", 'wp_dastak' ),
	"base" => "sh_about_carousel",
	"as_parent" => array( 'only' => 'sh_about_slide' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"show_settings_on_create" => false,
	'icon' => get_template_directory_uri() . '/images/icon/about-us-mockup-with-slide.png',
	'description' => __( 'Show about carousel ', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for about carousel", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "About us mockup with slide", 'wp_dastak' ),
	"base" => "sh_about_slide",
	"content_element" => true,
	"as_child" => array( 'only' => 'sh_about_carousel' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	'icon' => get_template_directory_uri() . '/images/icon/about-us-mockup-with-slide.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for about us section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "des",
			"description" => __( "Enter description for about us section", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "about_image",
			"value" => '',
			"description" => __( "Insert the image for about us section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Label", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter button label for about us section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button URL", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter button url for about us section", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Skills(Circular) Parallax", 'wp_dastak' ),
	"base" => "sh_posibilities",
	"as_parent" => array( 'only' => 'sh_percentage_block' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"show_settings_on_create" => false,
	'icon' => get_template_directory_uri() . '/images/icon/skills-circular-parallax.png',
	'description' => __( 'Endless Possibilities', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for fun facts", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Circular Skill", 'wp_dastak' ),
	"base" => "sh_percentage_block",
	"content_element" => true,
	"as_child" => array( 'only' => 'sh_posibilities' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	'icon' => get_template_directory_uri() . '/images/icon/skills-circular-parallax.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Percentage Value", 'wp_dastak' ),
			"param_name" => "value",
			"description" => __( "Enter percentage value", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Features Parallax Mockup", 'wp_dastak' ),
	"base" => "sh_features_banner1",
	"as_parent" => array( 'only' => 'sh_banner_slide' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"show_settings_on_create" => false,
	'icon' => get_template_directory_uri() . '/images/icon/features-parallax-mockup.png',
	'description' => __( 'Featues banner style one', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for feature banner", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter the sub title for feature", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description.", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the banner image", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert the background image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Banner Slide", 'wp_dastak' ),
	"base" => "sh_banner_slide",
	"content_element" => true,
	"as_child" => array( 'only' => 'sh_features_banner1' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	"icon" => 'faqs',
	"category" => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Slide Box One Title ", 'wp_dastak' ),
			"param_name" => "title1",
			"description" => __( "Enter slide box one title", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon Box One", 'wp_dastak' ),
			"param_name" => "icon1",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for box one", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Slide Box Two Title ", 'wp_dastak' ),
			"param_name" => "title2",
			"description" => __( "Enter slide box two title", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon Box Two", 'wp_dastak' ),
			"param_name" => "icon2",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for box one", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Slide Box Three Title ", 'wp_dastak' ),
			"param_name" => "title3",
			"description" => __( "Enter slide box three title", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon Box Three", 'wp_dastak' ),
			"param_name" => "icon3",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for box three", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Features Parallax Detailed", 'wp_dastak' ),
	"base" => "sh_features_banner2",
	"as_parent" => array( 'only' => 'sh_banner_feature' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"show_settings_on_create" => false,
	'icon' => get_template_directory_uri() . '/images/icon/features-parallax-detailed.png',
	'description' => __( 'Featues banner style two', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for feature banner", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter the sub title for feature", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description.", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the banner image", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "background_image",
			"value" => '',
			"description" => __( "Insert the background image", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Image Width", 'wp_dastak' ),
			"param_name" => "width",
			"description" => __( "Enter the value for image width", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Top Space", 'wp_dastak' ),
			"param_name" => "top",
			"description" => __( "Enter the value for image space from top", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Left Space", 'wp_dastak' ),
			"param_name" => "left",
			"description" => __( "Enter the value for image space from left", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Features Heading With Icon", 'wp_dastak' ),
	"base" => "sh_banner_feature",
	"content_element" => true,
	"as_child" => array( 'only' => 'sh_features_banner2' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	'icon' => get_template_directory_uri() . '/images/icon/features-heading-with-Icon.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter feature title", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon", 'wp_dastak' ),
			"param_name" => "icon",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for banner feature", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Features Banner Three", 'wp_dastak' ),
	"base" => "sh_features_banner3",
	"as_parent" => array( 'only' => 'sh_banner_feature3' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"content_element" => true,
	"show_settings_on_create" => false,
	'icon' => get_template_directory_uri() . '/images/icon/Features-Banner-Three.png',
	'description' => __( 'Featues banner style three', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for feature banner", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description.", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the banner image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Banner Feature", 'wp_dastak' ),
	"base" => "sh_banner_feature3",
	"content_element" => true,
	"as_child" => array( 'only' => 'sh_features_banner3' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	'icon' => 'faqs',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter feature title", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Icon", 'wp_dastak' ),
			"param_name" => "icon",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose font awesome icon for banner feature", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Gallery", 'wp_dastak' ),
	"base" => "sh_gallery",
	'description' => __( 'Gallery', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	'icon' => get_template_directory_uri() . '/images/icon/gallery.png',
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __( "Number of Galleris per page", 'wp_dastak' ),
			"param_name" => "per_page",
			"description" => __( "Enter the number of galleries per page", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			"value" => array( 'One Columns' => '12', 'Three Columns' => '4', 'Four Columns' => '3' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'gallery_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Masonary", 'wp_dastak' ),
			"param_name" => "masonary",
			"value" => array( 'True' => true, 'False' => false ),
			"description" => __( "Choose masonary to apply on gallery listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Our Offices", 'wp_dastak' ),
	"base" => "sh_our_offices",
	'description' => __( 'Our Offices', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/our-offices.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __( "Number of Offices", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of offices to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Our Branches", 'wp_dastak' ),
	"base" => "sh_our_branches",
	'description' => __( 'Our Branches', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Our-Branches-Listing.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __( "Number of Offices", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of offices to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Our Branches Listing", 'wp_dastak' ),
	"base" => "sh_our_branches2",
	'description' => __( 'Our Branches Listing', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for offices", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Number of Offices", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of offices to show", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "CEO Box", 'wp_dastak' ),
	"base" => "sh_ceo_box",
	'description' => __( 'CEO Box', 'wp_dastak' ),
	'category' => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/ceo-box.png',
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for ceo", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Designation", 'wp_dastak' ),
			"param_name" => "designation",
			"description" => __( "Enter the title for ceo box", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Decription", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description for ceo box", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "CEO Short Box", 'wp_dastak' ),
	"base" => "sh_ceo_box2",
	'description' => __( 'CEO Box Two', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/ceo-short-box.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		array(
			"type" => "textfield",
			"heading" => __( "Name", 'wp_dastak' ),
			"param_name" => "name",
			"description" => __( "Enter the name for ceo box", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			"heading" => __( "Decription", 'wp_dastak' ),
			"param_name" => "description",
			"description" => __( "Enter the description for ceo box", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the ceo image", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "History Listing", 'wp_dastak' ),
	"base" => "sh_history",
	'description' => __( 'History Listing', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/History-Listing.png',
	'category' => __( 'Dastak', 'wp_dastak' ),
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for history listing", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Number of Histories", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of histories to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "About us Mockup", 'wp_dastak' ),
	"base" => "sh_about_us",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/about-us.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for about us section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Our Areas", 'wp_dastak' ),
			"param_name" => "areas",
			"description" => __( "Enter areas as comma seperated", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "des",
			"description" => __( "Enter description for about us section", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "about_image",
			"value" => '',
			"description" => __( "Insert the image for about us section", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Our work with Carousel", 'wp_dastak' ),
	"base" => "sh_our_work_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/our-work-with-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of Projects to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'project_category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of projects .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of projects listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Projects Vertical Carousel", 'wp_dastak' ),
	"base" => "sh_our_work_carousel2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/projects-certical-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of Projects to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'project_category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of projects .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of porojects listing", 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Projects Carousel Detailed", 'wp_dastak' ),
	"base" => "sh_our_project",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/projects-carousel-detailed.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter Number of projects to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Category", 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'project_category', 'hide_empty' => false ) ) ),
			"description" => __( "Choose category of projects .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "sort",
			"value" => array( 'Date' => 'date', 'Title' => 'title', 'Name' => 'name', 'Author' => 'author', 'Rand' => 'random' ),
			"description" => __( "Choose Sort Option .", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( 'Ascending' => 'ASC', 'Descending' => 'DESC' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Clients Logos", 'wp_dastak' ),
	"base" => "sh_clients",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/clients-logos.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of clients to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			"value" => array( 'Six Columns' => '2', 'Four Columns' => '3', 'Three Columns' => '4', 'Two Columns' => '6' ),
			"description" => __( "Choose order of post listing", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'partner_category', 'hide_empty' => FALSE ), true ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image for clients listing parallax", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Case Studies(PDF Download)", 'wp_dastak' ),
	"base" => "sh_clients_case_studies1",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/case-studies.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of case studies to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Case Studies Accordion", 'wp_dastak' ),
	"base" => "sh_case_studies_accordion",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Case-Studies-Accordion.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of case studies to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
	)
);



$vc_array[] = array(
	"name" => __( "News", 'wp_dastak' ),
	"base" => "sh_news",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/news.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of news to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Recent Answers", 'wp_dastak' ),
	"base" => "sh_recent_answers",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/recent-answers.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of answers to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'faq_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array_flip( array( 'DESC' => __( 'Descending', 'wp_dastak' ), 'ASC' => __( 'Ascending', 'wp_dastak' ) ) ),
			"description" => __( "Selecct the order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Team Listing Detailed Info", 'wp_dastak' ),
	"base" => "sh_team",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/team-listing-detailed-Info.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of team members to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '3' => __( 'Four Columns', 'wp_dastak' ), '4' => __( 'Three Columns', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'team_category', 'hide_empty' => FALSE ), true ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Team Listing Short Info", 'wp_dastak' ),
	"base" => "sh_team2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/team-listing-short-info.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of team members to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'team_category', 'hide_empty' => FALSE ), true ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Team Listing Short Box Carousel", 'wp_dastak' ),
	"base" => "sh_team3",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Team-Listing-Short-Box-Carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of team members to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'team_category', 'hide_empty' => FALSE ), true ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Team Listing With Parallax", 'wp_dastak' ),
	"base" => "sh_team4",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/team-listing-with-parallax.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for team listing section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of team members to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'team_category', 'hide_empty' => FALSE ), true ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array_flip( array( 'DESC' => __( 'Descending', 'wp_dastak' ), 'ASC' => __( 'Ascending', 'wp_dastak' ) ) ),
			"description" => __( "Selecct the order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image for team listing parallax", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Team Leader Style 2", 'wp_dastak' ),
	"base" => "sh_team_member1",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Team-Leader-Style-Two.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for team section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Team Member", 'wp_dastak' ),
			"param_name" => "member",
			"value" => array_flip( sh_get_posts_array( 'sh_team', false ) ),
			"description" => __( "Select team member to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Team Leader Style 1", 'wp_dastak' ),
	"base" => "sh_team_member2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/team-leader-style1.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for team section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Team Member", 'wp_dastak' ),
			"param_name" => "member",
			"value" => array_flip( sh_get_posts_array( 'sh_team', false ) ),
			"description" => __( "Select team member to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Simple Team Members Carousel", 'wp_dastak' ),
	"base" => "sh_team_members_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/simple-team-members-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number Of Members", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter number of members to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'team_category', 'hide_empty' => FALSE ), true ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);


$vc_array[] = array(
	"name" => __( "Twitter Carousel With Parallax", 'wp_dastak' ),
	"base" => "sh_twitter_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/twitter-parallax.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Twitter ID", 'wp_dastak' ),
			"param_name" => "id",
			"description" => __( "Enter twitter id for twitter carousel", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number Of Tweets", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter number of tweets to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image for twitter section", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Twitter Widget Box", 'wp_dastak' ),
	"base" => "sh_twitter_carousel_two",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/twitter-widget-box.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for twitter carousel", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Twitter ID", 'wp_dastak' ),
			"param_name" => "id",
			"description" => __( "Enter twitter id for twitter carousel", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number Of Tweets", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter number of tweets to show", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Label", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter button label twitter carousel", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image for twitter section", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Flickr Feeds", 'wp_dastak' ),
	"base" => "sh_flickr_feeds",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/flickr-feeds.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Flickr ID", 'wp_dastak' ),
			"param_name" => "id",
			"description" => __( "Enter flickr id for flickr feeds", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number Of Feeds", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter number of feeds", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Testimonials List View Style", 'wp_dastak' ),
	"base" => "sh_testimonials_listing",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/testimonials-list-view-style.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array_flip( array( 'DESC' => __( 'Descending', 'wp_dastak' ), 'ASC' => __( 'Ascending', 'wp_dastak' ) ) ),
			"description" => __( "Selecct the order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Parallax Testimonials with Carousel", 'wp_dastak' ),
	"base" => "sh_testimonial_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/parallax-testimonials-with-Carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the background image for testimonials section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Parallax Scheme", 'wp_dastak' ),
			"param_name" => "parallax",
			'value' => array( 'Dark' => 'dark', 'White' => 'white', 'No Layer' => '' ),
			"description" => __( "Select parallax layer scheme", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Simple Testimonials Carousel", 'wp_dastak' ),
	"base" => "sh_testimonial_carousel2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/simple-testimonials-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for testimonial  section", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Testimonials Pictorials Tabs", 'wp_dastak' ),
	"base" => "sh_testimonial_carousel3",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/testimonials-pictorials-tabs.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of posts to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Events List", 'wp_dastak' ),
	"base" => "sh_events",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/events-list.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of events to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'upcoming' => __( 'Upcoming', 'wp_dastak' ), 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Events Detailed", 'wp_dastak' ),
	"base" => "sh_events2",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/events-detailed.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of events to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'upcoming' => __( 'Upcoming', 'wp_dastak' ), 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Events Grid Carousel", 'wp_dastak' ),
	"base" => "sh_events_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/events-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of events to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Number of Columns", 'wp_dastak' ),
			"param_name" => "cols",
			'value' => array_flip( array( '4' => __( 'Three Columns', 'wp_dastak' ), '6' => __( 'Two Columns', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'upcoming' => __( 'Upcoming', 'wp_dastak' ), 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'event_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Carousel", 'wp_dastak' ),
			"param_name" => "carousel",
			"value" => array( 'Enable Carousel' => true ),
			"description" => __( "Enable events carousel", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Single Project", 'wp_dastak' ),
	"base" => "sh_single_project",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/single-project.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for single project section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Project", 'wp_dastak' ),
			"param_name" => "project",
			'value' => array_flip( sh_get_posts_array( 'sh_project' ) ),
			"description" => __( "Select project to show", 'wp_dastak' )
		)
	)
);

$vc_array[] = array(
	"name" => __( "Single Portfolio", 'wp_dastak' ),
	"base" => "sh_single_portfolio",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/single-portfolio.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for single project section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Portfolio", 'wp_dastak' ),
			"param_name" => "portfolio",
			'value' => array_flip( sh_get_posts_array( 'sh_portfolio' ) ),
			"description" => __( "Select portfolio to show", 'wp_dastak' )
		)
	)
);

$vc_array[] = array(
	"name" => __( "Single Post", 'wp_dastak' ),
	"base" => "sh_single_post",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/single-post.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for single post section", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Post", 'wp_dastak' ),
			"param_name" => "post",
			'value' => array_flip( sh_get_posts_array( 'post' ) ),
			"description" => __( "Select post to show", 'wp_dastak' )
		)
	)
);

$vc_array[] = array(
	"name" => __( "Post Categories List", 'wp_dastak' ),
	"base" => "sh_post_categories_list",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/post-categories-list.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number of Categories", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter number of categories to show", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Mockup", 'wp_dastak' ),
	"base" => "sh_mockup",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/post-categories-list.png',
	"params" => array(
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Mockup Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Upload mockup image for mockup section", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Services With Text", 'wp_dastak' ),
	"base" => "sh_services_contents",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Services-With-Text.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			'value' => '',
			"description" => __( "Enter the title.", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "content",
			'value' => '',
			"description" => __( "Enter the content.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Contents Limit", 'wp_dastak' ),
			"param_name" => "limit",
			'value' => '',
			"description" => __( "Enter the number of charachters to show for each service.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Services Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'service_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category for services listing.', 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number of Services", 'wp_dastak' ),
			"param_name" => "num",
			'value' => '',
			"description" => __( "Enter number of services to show.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Select Grid', 'wp_dastak' ),
			"param_name" => "grid",
			"value" => array( 'Grid 1/2' => '6', 'Grid 1/3' => '4' ),
			"description" => __( 'Choose grid for services listing.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "orderby",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array( 'ASC' => __( 'Ascending', 'wp_dastak' ), 'DESC' => __( 'Descending', 'wp_dastak' ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Show More Button", 'wp_dastak' ),
			"param_name" => "more",
			"value" => array( 'Show More' => true ),
			"description" => __( "Check to show more button for services detail", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Show Services", 'wp_dastak' ),
			"param_name" => "services_listing",
			"value" => array( 'Show Services' => true ),
			"description" => __( "Enable to show services in this section", 'wp_dastak' )
		)
	)
);

$vc_array[] = array(
	"name" => __( "Products", 'wp_dastak' ),
	"base" => "sh_products",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/products.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "number",
			"value" => '',
			"description" => __( "Enter number of products", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Product Style", 'wp_dastak' ),
			"param_name" => "style",
			"value" => array( 'Style One' => 1, 'Style Two' => 2, 'Style Three' => 3, 'Style Four' => 4 ),
			"description" => __( "Select product listing style.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Columns", 'wp_dastak' ),
			"param_name" => "col",
			"value" => array( __( '4 Columns', 'wp_dastak' ) => 4, __( '3 Columns', 'wp_dastak' ) => 3, __( '2 Columns', 'wp_dastak' ) => 2 ),
			"description" => __( "Choose the number of columns", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'product_cat', 'hide_empty' => FALSE, 'show_all' => true ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "orderby",
			"value" => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'comment_count' => __( 'Comment Count', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Choose Sorting by.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sorting Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( __( 'Ascending Order', 'wp_dastak' ) => 'ASC', __( 'Descending Order', 'wp_dastak' ) => 'DESC' ),
			"description" => __( "Choose Sorting Order.", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Carousel", 'wp_dastak' ),
			"param_name" => "carousel",
			"value" => array( 'Enable Carousel' => true ),
			"description" => __( "Enable product carousel", 'wp_dastak' )
		),
		array(
			"type" => "checkbox",
			
			"class" => "",
			"heading" => __( "Social Icons", 'wp_dastak' ),
			"param_name" => "social_icons",
			"value" => array( 'Enable Social Icons' => true ),
			"description" => __( "Enable to show social icons on product listing Note: This optin will work only for product style four", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Custom Product", 'wp_dastak' ),
	"base" => "sh_product_add",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/Custom-Product.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"value" => '',
			"description" => __( "Enter title", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter the sub title for the section", 'wp_dastak' )
		),
		array(
			"type" => "textarea",
			
			"class" => "",
			"heading" => __( "Description", 'wp_dastak' ),
			"param_name" => "content",
			'value' => '',
			"description" => __( "Enter the content.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button Label", 'wp_dastak' ),
			"param_name" => "label",
			"description" => __( "Enter the button label", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Button URL", 'wp_dastak' ),
			"param_name" => "url",
			"description" => __( "Enter the button URL", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Insert the image for this add section", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Deals Carousel", 'wp_dastak' ),
	"base" => "sh_deals_carousel",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/deals-carousel.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "number",
			"value" => '',
			"description" => __( "Enter number of deals to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sort By", 'wp_dastak' ),
			"param_name" => "orderby",
			"value" => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Choose Sorting by.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Sorting Order", 'wp_dastak' ),
			"param_name" => "order",
			"value" => array( __( 'Ascending Order', 'wp_dastak' ) => 'ASC', __( 'Descending Order', 'wp_dastak' ) => 'DESC' ),
			"description" => __( "Choose Sorting Order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Jobs Listing With Small Thumb", 'wp_dastak' ),
	"base" => "sh_jobs",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/jobs-listing-detailed.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of jobs to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'testimonial_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Jobs Listing Detailed", 'wp_dastak' ),
	"base" => "sh_jobs3",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/jobs-listing-detailed.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Number", 'wp_dastak' ),
			"param_name" => "num",
			"description" => __( "Enter the number of jobs to show", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( 'Category', 'wp_dastak' ),
			"param_name" => "cat",
			"value" => array_flip( sh_get_categories( array( 'taxonomy' => 'job_category', 'hide_empty' => FALSE ) ) ),
			"description" => __( 'Choose Category.', 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order By", 'wp_dastak' ),
			"param_name" => "sort",
			'value' => array_flip( array( 'date' => __( 'Date', 'wp_dastak' ), 'title' => __( 'Title', 'wp_dastak' ), 'name' => __( 'Name', 'wp_dastak' ), 'author' => __( 'Author', 'wp_dastak' ), 'random' => __( 'Random', 'wp_dastak' ), 'id' => __( 'ID', 'wp_dastak' ) ) ),
			"description" => __( "Enter the sorting order.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Order", 'wp_dastak' ),
			"param_name" => "order",
			'value' => array_flip( array( 'DESC' => __( 'Descending', 'wp_dastak' ), 'ASC' => __( 'Ascending', 'wp_dastak' ) ) ),
			"description" => __( "Selecct the order.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Job Application Form", 'wp_dastak' ),
	"base" => "sh_job_application_form",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/job-application-form.png',
	"params" => array(
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Select Form", 'wp_dastak' ),
			"param_name" => "form",
			"value" => array_flip( sh_get_posts_array( 'sh_forms', false ) ),
			"description" => __( "Select form to show", 'wp_dastak' )
		),
	)
);

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_Sh_About_Carousel extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_About_Slide extends WPBakeryShortCode {

}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_Sh_Posibilities extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Percentage_Block extends WPBakeryShortCode {

}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_SH_Features_Banner1 extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Feature_Slide extends WPBakeryShortCode {

}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_SH_Features_Banner2 extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Banner_Feature extends WPBakeryShortCode {

}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_SH_Features_Banner3 extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Banner_Feature3 extends WPBakeryShortCode {

}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_SH_Content_Box_Parallax extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Contents_List extends WPBakeryShortCode {

}

/** Price TAble and price table features */
//Register "container" content element. It will hold all your inner (child) content elements
$vc_array[] = array(
	"name" => __( "Price Table", 'wp_dastak' ),
	"base" => "sh_ptable",
	"as_parent" => array( 'only' => 'sh_ptable_features' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/price-table.png',
	"content_element" => true,
	"show_settings_on_create" => false,
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for pricing table", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Price", 'wp_dastak' ),
			"param_name" => "price",
			"description" => __( "Enter the price", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Price Symbol", 'wp_dastak' ),
			"param_name" => "symbol",
			"description" => __( "Enter the price symbol", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Price Period", 'wp_dastak' ),
			"param_name" => "period",
			"description" => __( "Enter the period for price", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Button Label", 'wp_dastak' ),
			"param_name" => "btn",
			"description" => __( "Enter the button label", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Button LInk", 'wp_dastak' ),
			"param_name" => "btn_link",
			"description" => __( "Enter the button link", 'wp_dastak' )
		),
	),
	"js_view" => 'VcColumnView'
);

$vc_array[] = array(
	"name" => __( "Price Table Feature", 'wp_dastak' ),
	"base" => "sh_ptable_features",
	"content_element" => true,
	"icon" => get_template_directory_uri() . '/images/icon/price-table.png',
	"category" => __( 'Dastak', 'wp_dastak' ),
	"as_child" => array( 'only' => 'sh_ptable' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textarea",
			"heading" => __( "Content", 'wp_dastak' ),
			"param_name" => "content",
			"description" => __( "Add the pricing table features", 'wp_dastak' ),
			'value' => ''
		),
	)
);

/** Price TAble and price table features */
//Register "container" content element. It will hold all your inner (child) content elements
$vc_array[] = array(
	"name" => __( "Fancy Price Table", 'wp_dastak' ),
	"base" => "sh_fancy_ptable",
	"as_parent" => array( 'only' => 'sh_fancy_ptable_features' ), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/price-table.png',
	"content_element" => true,
	"show_settings_on_create" => false,
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textfield",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter the title for pricing table", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Price", 'wp_dastak' ),
			"param_name" => "price",
			"description" => __( "Enter the price", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Price Symbol", 'wp_dastak' ),
			"param_name" => "symbol",
			"description" => __( "Enter the price symbol", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Price Period", 'wp_dastak' ),
			"param_name" => "period",
			"description" => __( "Enter the period for price", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Button Label", 'wp_dastak' ),
			"param_name" => "btn",
			"description" => __( "Enter the button label", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			"heading" => __( "Button LInk", 'wp_dastak' ),
			"param_name" => "btn_link",
			"description" => __( "Enter the button link", 'wp_dastak' )
		),
		array(
			"type" => "attach_image",
			
			"class" => "",
			"heading" => __( "Background Image", 'wp_dastak' ),
			"param_name" => "image",
			"value" => '',
			"description" => __( "Upload background image for this price table", 'wp_dastak' )
		),
	),
	"js_view" => 'VcColumnView'
);

$vc_array[] = array(
	"name" => __( "Fancy Price Table Feature", 'wp_dastak' ),
	"base" => "sh_fancy_ptable_features",
	"content_element" => true,
	"icon" => get_template_directory_uri() . '/images/icon/price-table.png',
	"category" => __( 'Dastak', 'wp_dastak' ),
	"as_child" => array( 'only' => 'sh_fancy_ptable' ), // Use only|except attributes to limit parent (separate multiple values with comma)
	"params" => array(
		// add params same as with any other content element
		array(
			"type" => "textarea",
			"heading" => __( "Content", 'wp_dastak' ),
			"param_name" => "content",
			"description" => __( "Add the pricing table features", 'wp_dastak' ),
			'value' => ''
		),
	)
);

$vc_array[] = array(
	"name" => __( "Headings", 'wp_dastak' ),
	"base" => "sh_headings",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/headings.png',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			'value' => '',
			"description" => __( "Enter the title.", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			'value' => '',
			"description" => __( "Enter the sub title.", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			
			"class" => "",
			"heading" => __( "Heading Style", 'wp_dastak' ),
			"param_name" => "style",
			"value" => array( __( 'Heading Style 1', 'wp_dastak' ) => '1', __( 'Heading Style 2', 'wp_dastak' ) => '2', __( 'Heading Style 3', 'wp_dastak' ) => '3', __( 'Heading Style 4', 'wp_dastak' ) => '4', __( 'Heading Style 5', 'wp_dastak' ) => '5', __( 'Heading Style 6', 'wp_dastak' ) => '6', __( 'Heading Style 7', 'wp_dastak' ) => '7', __( 'Heading Style 8', 'wp_dastak' ) => '8' ),
			"description" => __( "Choose style for heading", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Contact Info", 'wp_dastak' ),
	"base" => "sh_contact_info",
	"class" => "",
	"category" => __( 'Dastak', 'wp_dastak' ),
	"icon" => get_template_directory_uri() . '/images/icon/contact-us-style.png',
	"as_parent" => array( 'only' => 'sh_contact_info_item' ),
	"content_element" => true,
	"show_settings_on_create" => false,
	"js_view" => 'VcColumnView',
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for contact info shortcode Note: This title will not show on frontend.", 'wp_dastak' )
		),
	)
);

$vc_array[] = array(
	"name" => __( "Contact Info Item", 'wp_dastak' ),
	"base" => "sh_contact_info_item",
	"content_element" => true,
	"icon" => get_template_directory_uri() . '/images/icon/price-table.png',
	"category" => __( 'Dastak', 'wp_dastak' ),
	"as_child" => array( 'only' => 'sh_contact_info' ),
	"params" => array(
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Title", 'wp_dastak' ),
			"param_name" => "title",
			"description" => __( "Enter title for contact info item", 'wp_dastak' )
		),
		array(
			"type" => "textfield",
			
			"class" => "",
			"heading" => __( "Sub Title", 'wp_dastak' ),
			"param_name" => "sub_title",
			"description" => __( "Enter sub title for contact info item", 'wp_dastak' )
		),
		array(
			"type" => "dropdown",
			"heading" => __( "Item Icon", 'wp_dastak' ),
			"param_name" => "icon",
			'value' => array_flip( sh_font_awesome() ),
			"description" => __( "Choose the icon contact info item", 'wp_dastak' )
		),
	)
);



foreach ( $vc_array as $vc_arr ) {

	foreach ( sh_set( $vc_arr, 'params' ) as $k => $param ) {
		if ( sh_set( $param, 'type' ) == 'dropdown' ) {

			if ( array_key_exists( 'value', $param ) ) {
				$new_elment = array( __( 'Please select', SH_NAME ) . ' ' . strtolower( sh_set( $param, 'heading' ) ) => 0 );
				$param['value'] = array_merge( $new_elment, $param['value'] );
				$vc_arr['params'][$k]['value'] = $param['value'];
			}
		}
	}

	vc_map( $vc_arr );
}

//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
class WPBakeryShortCode_Sh_Ptable extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Ptable_Features extends WPBakeryShortCode {

}

class WPBakeryShortCode_Sh_Fancy_Ptable extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Fancy_Ptable_Features extends WPBakeryShortCode {

}

class WPBakeryShortCode_Sh_Contact_Info extends WPBakeryShortCodesContainer {

}

class WPBakeryShortCode_Sh_Contact_Info_Item extends WPBakeryShortCode {

}

/*function sh_custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		$class_string = str_replace( 'vc_row-fluid', ' ', $class_string ); // This will replace "vc_row-fluid" with "my_row-fluid"
	}
	if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		$class_string = preg_replace( '/vc_col-sm-(\d{1,2})/', 'col-md-$1', $class_string ); // This will replace "vc_col-sm-%" with "my_col-sm-%"

	}

	return $class_string;

}*/

// Filter to Replace default css class for vc_row shortcode and vc_column
//add_filter( 'vc_shortcodes_css_class', 'sh_custom_css_classes_for_vc_row_and_vc_column', 10, 2 );

function vc_theme_vc_row( $atts, $content = null ) {

	extract( shortcode_atts( array(
		'el_class' => '',
		'full_height'=> '', 
		'parallax_speed_bg'=> '', 
		'parallax_speed_video'=> '',  
		'full_width'=> '',  
		'equal_height'=> '',  
		'flex_row'=> '',  
		'columns_placement'=> '', 
		'content_placement'=> '', 
		'parallax'=> '', 
		'parallax_image'=> '',  
		'css'=> '',  
		'el_id'=> '',  
		'video_bg'=> '', 
		'video_bg_url'=> '',  
		'video_bg_parallax'=> '',  
		'css_animation'=> '',  


		
		'bg_image' => '',
		'bg_color' => '',
		'bg_image_repeat' => '',
		'font_color' => '',
		'padding' => '',
		'margin_bottom' => '',
		'remove_gap' => '',
		'use_pattern' => '',
		'container' => '',
		'col_title' => '',
		'col_sub_title' => '',
		'heading_style' => '',
		'pattern_scheme' => '',
		'pattern_image' => '',
		'remove_bottom' => '',
		'width_class' => '',
	/*	'css' => '',
		'parallax' =>'',
		'parallax_image' => '',
		'parallax_speed_bg'=> '',*/
					), $atts ) );

	$atts['base'] = '';
$vc_row = new WPBakeryShortCode_VC_Row( $atts );

	/*wp_enqueue_style( 'js_composer_front' );
	wp_enqueue_script( 'wpb_composer_front_js' );
	wp_enqueue_style( 'js_composer_custom_css' );
	
	*/

	//$el_class = $full_height = $parallax_speed_bg = $parallax_speed_video = $full_width = $equal_height = $flex_row = $columns_placement = $content_placement = $parallax = $parallax_image = $css = $el_id = $video_bg = $video_bg_url = $video_bg_parallax = $css_animation = '';
$disable_element = '';

$output = $after_output = '';
/*$atts = vc_map_get_attributes( getShortcode(), $atts );
extract( $atts );*/

wp_enqueue_script( 'wpb_composer_front_js' );

$el_class = $vc_row->getExtraClass( $el_class ) . $vc_row->getCSSAnimation( $css_animation );

$css_classes = array(

	//$inner_gap_option,
	$el_class,
	vc_shortcode_custom_css_class( $css ),
); 
if ( 'yes' === $disable_element ) {
	if ( vc_is_page_editable() ) {
		$css_classes[] = 'vc_hidden-lg vc_hidden-xs vc_hidden-sm vc_hidden-md';
	} else {
		return '';
	}
}
if ( vc_shortcode_custom_css_has_property( $css, array(
		'border',
		'background',
	) ) || $video_bg || $parallax
) {
	$css_classes[] = 'vc_row-has-fill';
}

if ( ! empty( $atts['gap'] ) ) {
	$css_classes[] = 'vc_column-gap-' . $atts['gap'];
}
$wrapper_attributes = array();

if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
if ( ! empty( $full_width ) ) {
	$wrapper_attributes[] = 'data-vc-full-width="true"';
	$wrapper_attributes[] = 'data-vc-full-width-init="false"';
	if ( 'stretch_row_content' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
	} elseif ( 'stretch_row_content_no_spaces' === $full_width ) {
		$wrapper_attributes[] = 'data-vc-stretch-content="true"';
		$css_classes[] = 'vc_row-no-padding';
	}
	$after_output .= '<div class="vc_row-full-width vc_clearfix"></div>';
}

if ( ! empty( $full_height ) ) {
	$css_classes[] = 'vc_row-o-full-height';
	if ( ! empty( $columns_placement ) ) {
		$flex_row = true;
		$css_classes[] = 'vc_row-o-columns-' . $columns_placement;
		if ( 'stretch' === $columns_placement ) {
			$css_classes[] = 'vc_row-o-equal-height';
		}
	}
}

if ( ! empty( $equal_height ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-equal-height';
}

if ( ! empty( $content_placement ) ) {
	$flex_row = true;
	$css_classes[] = 'vc_row-o-content-' . $content_placement;
}

if ( ! empty( $flex_row ) ) {
	$css_classes[] = 'vc_row-flex';
}

$has_video_bg = ( ! empty( $video_bg ) && ! empty( $video_bg_url ) && vc_extract_youtube_id( $video_bg_url ) );

$parallax_speed = $parallax_speed_bg;
if ( $has_video_bg ) {
	$parallax = $video_bg_parallax;
	$parallax_speed = $parallax_speed_video;
	$parallax_image = $video_bg_url;
	$css_classes[] = 'vc_video-bg-container';
	wp_enqueue_script( 'vc_youtube_iframe_api_js' );
}

if ( ! empty( $parallax ) ) {
	wp_enqueue_script( 'vc_jquery_skrollr_js' );
	$wrapper_attributes[] = 'data-vc-parallax="' . esc_attr( $parallax_speed ) . '"'; // parallax speed
	$css_classes[] = 'vc_general vc_parallax vc_parallax-' . $parallax;
	if ( false !== strpos( $parallax, 'fade' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fade';
		$wrapper_attributes[] = 'data-vc-parallax-o-fade="on"';
	} elseif ( false !== strpos( $parallax, 'fixed' ) ) {
		$css_classes[] = 'js-vc_parallax-o-fixed';
	}
}

if ( ! empty( $parallax_image ) ) {
	if ( $has_video_bg ) {
		$parallax_image_src = $parallax_image;
	} else {
		$parallax_image_id = preg_replace( '/[^\d]/', '', $parallax_image );
		$parallax_image_src = wp_get_attachment_image_src( $parallax_image_id, 'full' );
		if ( ! empty( $parallax_image_src[0] ) ) {
			$parallax_image_src = $parallax_image_src[0];
		}
	}
	$wrapper_attributes[] = 'data-vc-parallax-image="' . esc_attr( $parallax_image_src ) . '"';
}
if ( ! $parallax && $has_video_bg ) {
	$wrapper_attributes[] = 'data-vc-video-bg="' . esc_attr( $video_bg_url ) . '"';
}

$css_class = preg_replace( '/\s+/', ' ', apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, implode( ' ', array_filter( array_unique( $css_classes ) ) ),$atts['base'], $atts ) );
$wrapper_attributes[] = 'class="' . esc_attr( trim( $css_class ) ) . '"';




	$output = '';

	$css_class = ($remove_gap) ? ' remove-gap ' . $el_class : $el_class;

	$css_class = ($remove_bottom) ? ' remove-bottom ' . $css_class : $css_class;

	$css_class = ($pattern_scheme && $use_pattern ) ? $pattern_scheme . ' ' . $css_class : $css_class;

	$css_class = ($use_pattern) ? ' gray ' . $css_class : $css_class;

	$css_class = ($css) ? apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts['base'], $atts ) . ' ' . $css_class : $css_class;

	$background_image = ($pattern_image) ? 'style="background-image:url(' . wp_get_attachment_url( $pattern_image ) . ');"' : '';

	$style = $vc_row->buildStyle( $bg_image, $bg_color, $bg_image_repeat, $font_color, $padding, $margin_bottom );

	if ( $container == true ) {

		$output .= '<section  ' . $style . ' class="block ' . $css_class . '" ' . $background_image . '><div class="container"><div class="row">';
		
$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
		if ( $col_title ) {
			$output .= '<div class="col-md-12">' . sh_get_section_title( $col_title, $col_sub_title, $heading_style ) . '</div>';
		};
		$output .= wpb_js_remove_wpautop( $content );
		$output .='</div></div></div></section>';
	} else {

		$output .='<section ' . $style . ' class="block ' . $css_class . '" ' . $background_image . '><div class="row">';

$output .= '<div ' . implode( ' ', $wrapper_attributes ) . '>';
		if ( $col_title ) {
			$output .= '<div class="col-md-12">' . sh_get_section_title( $col_title, $col_sub_title, $heading_style ) . '</div>';
		};
		$output .= wpb_js_remove_wpautop( $content );

		$output .= '</div></div></section>';
	}
	return $output;
}

function vc_theme_vc_column( $atts, $content = null ) {

	extract( shortcode_atts( array( 
		'width' => '', 
		'el_class' => '', 
		'col_title' => '', 
		'col_sub_title' => '', 
		'heading_style' => '',
		'css' => '',
		 'offset' => '',


		 ), 
	$atts ) );
		$atts['base'] = '';

  $el_class22 = ($css) ? apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), $atts['base'], $atts ) . ' ' . $el_class : $el_class;
	
	$width_col = wpb_translateColumnWidthToSpan( $width );


	$width = str_replace( 'vc_col-sm-', 'col-md-', $width_col );
 $ofset = str_replace('vc_', '', $offset . ' column');
	$el_class = ($el_class22) ? ' ' . $el_class22 : '';



	$output = '<div class="' . $width . $el_class .  $offset. '">';
	if ( $col_title ) {
		$output .= sh_get_section_title( $col_title, $col_sub_title, $heading_style );
	};
	$output .= do_shortcode( $content );
	$output .='</div>';

	return $output;
}

$remove_gap = array(
	"type" => "checkbox",
	
	"class" => "",
	"heading" => __( "Remove Gap", 'wp_dastak' ),
	"param_name" => "remove_gap",
	"value" => array( 'Remove Spaces' => 'remove-gap' ),
	"description" => __( "Choose whether you want to remove extra spaces from top.", 'wp_dastak' )
);

$remove_bottom = array(
	"type" => "checkbox",
	
	"class" => "",
	"heading" => __( "Remove Bottom Space", 'wp_dastak' ),
	"param_name" => "remove_bottom",
	"value" => array( 'Remove Bottom Spaces' => 'remove-bottom' ),
	"description" => __( "Choose whether you want to remove extra spaces from bottom.", 'wp_dastak' )
);

$pattern = array(
	"type" => "checkbox",
	
	"class" => "",
	"heading" => __( "Use Pattern", 'wp_dastak' ),
	"param_name" => "use_pattern",
	"value" => array( 'Use Pattern' => true ),
	"description" => __( "Choose whether you want to use pattern for this shortcode.", 'wp_dastak' )
);

$container = array(
	"type" => "checkbox",
	
	"class" => "",
	"heading" => __( "Container", 'wp_dastak' ),
	"param_name" => "container",
	"value" => array( 'Container' => true ),
	"description" => __( "Choose whether you want to enable container for this shortcode or not.", 'wp_dastak' )
);

$title = array(
	"type" => "textfield",
	
	"class" => "",
	"heading" => __( "Enter the Title", 'wp_dastak' ),
	"param_name" => "col_title",
	"description" => __( "Enter the title of this section. Use i tag to style the specific charachter of title e.g About <code>&lt;i&gt;Us&lt;/i&gt;</code>", 'wp_dastak' )
);
$sub_title = array(
	"type" => "textfield",
	
	"class" => "",
	"heading" => __( "Enter the Sub Title", 'wp_dastak' ),
	"param_name" => "col_sub_title",
	"description" => __( "Enter the sub title of this section.", 'wp_dastak' )
);
$heading = array(
	"type" => "dropdown",
	
	"class" => "",
	"heading" => __( "Heading Style", 'wp_dastak' ),
	"param_name" => "heading_style",
	"value" => array( __( 'Please Select Title Style', 'wp_dastak' ) => '', __( 'Heading Style 1', 'wp_dastak' ) => '1', __( 'Heading Style 2', 'wp_dastak' ) => '2', __( 'Heading Style 3', 'wp_dastak' ) => '3', __( 'Heading Style 4', 'wp_dastak' ) => '4', __( 'Heading Style 5', 'wp_dastak' ) => '5', __( 'Heading Style 6', 'wp_dastak' ) => '6', __( 'Heading Style 7', 'wp_dastak' ) => '7', __( 'Heading Style 8', 'wp_dastak' ) => '8' ),
	"description" => __( "Select the heading style for this section.", 'wp_dastak' )
);

$pattern_scheme = array(
	"type" => "dropdown",
	
	"class" => "",
	"heading" => __( "Pattern Scheme", 'wp_dastak' ),
	"param_name" => "pattern_scheme",
	"value" => array( __( 'Please Select Pattern Scheme', 'wp_dastak' ) => '', __( 'Light', 'wp_dastak' ) => 'light-pattern', __( 'Dark', 'wp_dastak' ) => 'dark-pattern' ),
	"description" => __( "Select the pattern scheme for this section.", 'wp_dastak' )
);
$pattern_image = array(
	"type" => "attach_image",
	
	"class" => "",
	"heading" => __( "Upload Pattern", 'wp_dastak' ),
	"param_name" => "pattern_image",
	"value" => '',
	"description" => __( "Upload pattern image for this section.", 'wp_dastak' )
);

vc_add_param( 'vc_column', $title );
vc_add_param( 'vc_column', $sub_title );
vc_add_param( 'vc_column', $heading );
vc_add_param( 'vc_row', $title );
vc_add_param( 'vc_row', $sub_title );
vc_add_param( 'vc_row', $heading );
vc_add_param( 'vc_row', $remove_gap );
vc_add_param( 'vc_row', $remove_bottom );
vc_add_param( 'vc_row', $pattern );
vc_add_param( 'vc_row', $container );
vc_add_param( 'vc_row', $pattern_scheme );
vc_add_param( 'vc_row', $pattern_image );

vc_disable_frontend();



