<?php if ( ! defined('ABSPATH')) exit('restricted access'); 

add_action( 'widgets_init', 'theme_register_sidebars' );

function theme_register_sidebars()
{	
	global $_webnukes;
	
	//EXAMPLE HOW TO REGISTER SIDEBAR
	
	/** Blog Sidebar */
	/*
	register_sidebar(
		array( 'id' => 'homepage-sidebar1',
			'name' => __( 'Homepage Sidebar 1', THEME_NAME ),
			'description' => 'Widgets in this area will be shown on the Blog Posts Pages.',
			'before_widget' => '<div id="%1$s" class="block %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<div class="heading">',
			'after_title' => '</div>'
		)
	);*/
	
	/** Create dynamic sidebars */
	$settings = $_webnukes->get_settings('sidebar_creator');
	
	if($_webnukes->kvalue($settings,'status') == 'active')
	{
		if($_webnukes->kvalue($settings,'DYNAMIC'))
		{	
			foreach($_webnukes->kvalue($settings,'DYNAMIC') as $key=>$val)
			{
				$name = ($_webnukes->kvalue($val,'name')) ? $val['name'] : __('Dynamic Sidebar ', 'wp_dastak').$key;
				
				$id = ($_webnukes->kvalue($val,'id')) ? $val['id'] : 'dynamic-sidebar'.$key;
				
				$before_title = '<div class="title"><h1>';
				$after_title = '</h1></div>';
				$class = 'block';

				/** Register Dynamic Sidebar */
				register_sidebar(
					array( 'id' => $id,
						'name' => $name,
						'before_widget' => '<div id="%1$s" class="'.$class.' %2$s">',
						'after_widget' => '</div>',
						'before_title' => $before_title,
						'after_title' => $after_title
					)
				);
			}
		}
	}
}


/**
 * Function is used to load dynamically created sidebars
 *
 * @param	string		$tpl_name		Name of WP template file where do you want to show the sidebar
 * @param	string		$default		id/Name of the default sidebar if provided $tpl_name doesn't find.
 * @return	string						prints the dyanmic created html of sidebar if found else prints nothing
 */
function _load_dynamic_sidebar($tpl_name, $default = 'blog-sidebar')
{
	global $_webnukes;
	
	$settings = get_option(THEME_PREFIX.'sidebar_creator');
			
	if($_webnukes->kvalue($settings, 'status') == 'active')
	{
		$tmpls = array_reduce( (array)$_webnukes->kvalue($settings, 'DYNAMIC'), create_function('$new_tpl, $v', '$new_tpl[$v["template"]] = $v; return $new_tpl;') );

		if($sidebar = $_webnukes->kvalue($tmpls, $tpl_name)) 
		{
			if(is_active_sidebar($_webnukes->kvalue($sidebar, 'id'))) dynamic_sidebar($sidebar['id']);
		}else dynamic_sidebar($default);
	}else dynamic_sidebar($default);
}