<?php if ( ! defined('ABSPATH')) exit('restricted access');

if( ! is_admin())
{
	/** Include styles and scripts */
	add_action('wp_enqueue_scripts', 'fw_enqueue_scripts');
	
	/** add action to wp_print_styles for print our styles */
	add_action('wp_head', 'fw_theme_head', 30);
	
	/** add action wp_footer */
	add_action('wp_footer', 'fw_theme_footer');
}

function fw_enqueue_scripts()
{
	$css_dir = THEME_URL . 'css/';
	$js_dir = THEME_URL . 'js/';
	
	
	/** Include Javascripts */
	if(is_home()) $scripts = array();
	//elseif(is_category()) $scripts = array();
	
	/** register and enqueue scripts */
	foreach($scripts as $js => $file)
	{
		wp_register_script($js, $js_dir.$file, array(), '', true);
		wp_enqueue_script($js);
	}
	
	/** Include style files */
	$styles = array (
		'main-styles' => 'style.css',
	);
	
	foreach($styles as $css=>$file)
	{
		/** register our stylesheets from array */
		wp_register_style($css, THEME_URL.'/'.$file, false, '1.0', 'screen' );
		
		/** enqueue our stylesheets */
		wp_enqueue_style($css);
	}
}

function fw_theme_head()
{
	global $_webnukes;
	
	echo $_webnukes->get_settings('general_settings', 'header_code');
}

function fw_theme_footer()
{
	global $_webnukes;
	
	echo $_webnukes->get_settings('general_settings', 'footer_code');
}