<?php /* Template Name: Signup */ 
if( is_user_logged_in() || get_option('users_can_register') != 1 ) 
{
	wp_redirect( home_url() );
	exit;
}
?> 
<?php get_header();?>
<?php $meta_settings  = get_post_meta(get_the_ID(), 'sh_page_meta', true);?>
<?php $meta_values = $meta_settings['sh_post_options'];?>
<?php $settings = get_option( 'wp_dastak'.'_theme_options' );//printr($settings);?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo (sh_get_meta_value(get_the_ID(), 'header_image')) ? 'style="background-image:url('.sh_get_meta_value(get_the_ID(), 'header_image').');"' : '';?>></div> 
		<div class="container">
			<div class="inner-head">
				<div class="inner-title">
					<h2><?php echo (sh_get_meta_value(get_the_ID(), 'banner_title')) ? sh_get_meta_value(get_the_ID(), 'banner_title') : get_the_title(get_the_ID());?></h2>
					<span><?php echo sh_get_meta_value(get_the_ID(), 'sub_title'); ?></span>
				</div>
				<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section>

<section class="block register-sec" <?php echo (sh_set($settings, 'register_image')) ? 'style="background-image:url('.sh_set($settings, 'register_image').');"' : '';?>>
	<div class="container">
		<div class="row">
			<div class="col-md-6">
				<div class="register-form">
					<div class="row">
						<h3><?php echo sh_set($settings, 'register_title');?></h3>
                        <?php if(isset($_POST) && $_POST) sh_create_user($_POST); ?>
                        <form action="<?php echo get_permalink();?>" method="post"> 
                            <div class="col-md-12">
                                <div class="fields">
                                    <i class="fa fa-envelope-o"></i><input type="text" name="user_email" placeholder="<?php _e('Your Email Address', 'wp_dastak')?>" /> 
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="fields">
                                    <i class="fa fa-user"></i><input name="user_login" type="text" placeholder="<?php _e('Create a Username', 'wp_dastak')?>" /> 
                                </div>
                            </div>
                            	
                            <div class="col-md-6">
                                <div class="fields">
                                    <i class="fa fa-male"></i><input type="text" name="first_name" placeholder="<?php _e('First Name', 'wp_dastak');?>" /> 
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="fields">
                                    <i class="fa fa-male"></i><input type="text" name="last_name" placeholder="<?php _e('Last Name', 'wp_dastak')?>" /> 
                                 </div>
                            </div>
                      
                            <div class="col-md-12">
                                <div class="submit-form">
                                    <input type="submit" value="<?php _e('Complete Sign-Up', 'wp_dastak');?>" />
                                    <p><?php echo sh_set($settings, 'register_description');?></p>
                                </div>
                            </div>
                        </form>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php get_footer();?>