<?php
/* Template Name: Forgot Password */

if( is_user_logged_in() ) 
{
	wp_redirect( home_url() );
	exit;
}
get_header();
$theme_settings = get_option('wp_dastak'.'_theme_options');//printr($settings);
$meta_settings  = get_post_meta(get_the_ID(), 'sh_page_meta', true);
$settings = sh_set( sh_set( $meta_settings, 'sh_post_options' ), 0 );
$sidebar = sh_set( $settings, 'sidebar' );

$layout = sh_set( $settings, 'layout', 'full' );
$paged = get_query_var('paged');
$bg_image = (sh_set($settings, 'blog_page_header_image')) ? 'style="background:url('.sh_set($settings, 'blog_page_header_image').');"' : '';
?>
<?php if( !sh_set( $settings, 'is_home' ) ): ?>
    <section id="inner-head" class="block">
	<div class="fixed-img sec-bg4" <?php echo $bg_image;?>></div>
	<div class="container">	
		<h1><?php echo sh_set($settings, 'banner_title');?></h1>
	</div>
</section>
<?php endif; ?>
<!-- Page Top Image -->


<section class="block" id="login-bg" <?php echo (sh_set($theme_settings, 'forgot_password_image')) ? 'style="background-image:url('.sh_set($theme_settings, 'forgot_password_image').');"' : '';?>>
	<div class="container">
    	 <?php if( !sh_set( $settings, 'is_home' ) && sh_set($settings, 'page_title') == true ): ?>
            
            <div class="page-title">
              <?php echo sh_get_title( get_the_title(), 'h1', 'span', FALSE );?>  
            </div>
            
        <?php endif; ?>
		<div class="login-sec">
			
			  <div class="tab-content">
				<div class="register-form">
                	<div class="row">
						<?php do_action('lost_password'); ?>
                        <h3><?php _e('Lost Password', 'wp_ducan');?></h3>
                        <form action="<?php echo wp_lostpassword_url(esc_url(get_permalink())); ?>" method="post">
                            <div class="col-md-12">   
                               <div class="form-style">
                                    <i class="fa fa-envelope-o"></i><input class="input" type="text" name="user_login" id="user_login"  placeholder="<?php _e('Username or E-mail', 'wp_ducan');?>" value="<?php echo esc_attr(sh_set($_POST, 'user_login')); ?>" size="20" />
                               </div>
                           </div>
                           <div class="col-md-12">  
                                <div class="submit-form">
                                    <input type="hidden" name="redirect_to" value="<?php echo esc_url( get_permalink() ); ?>" />
                                    <input type="submit" name="wp-submit" id="wp-submit" class="btn btn-cyan" value="<?php _e('Get New Password', 'wp_ducan'); ?>" />
                                    <p><?php _e('Please enter your username or email address. You will receive a link to create a new password via email.', 'wp_ducan');?></p>
                                </div>
                           </div>
                        </form>
                    </div>
				</div><!-- Sign in Form -->
			 </div>
			 
		</div>
	</div>
</section>
<?php get_footer(); ?>