<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive.
 *
 * Override this template by copying it to yourtheme/woocommerce/archive-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
global $wp_query;//printr($wp_query);?>
<?php get_header('shop'); ?>
<?php
	$page_id = wc_get_page_id( 'shop' );
	$layout = sh_get_meta_value($page_id, 'layout');//printr($layout);
	$sidebar = sh_get_meta_value($page_id, 'sidebar'); 
	$meta_settings  = get_post_meta($page_id, 'sh_page_meta', true);
    $meta_values = sh_set($meta_settings, 'sh_post_options'); //printr($meta_values);
	$settings = get_option( 'wp_dastak'.'_theme_options' );//printr($settings);
?>

<section class="block inner-head-sec">
	<div class="dark">
		<div class="fixed-img sec-bg8" <?php echo (sh_get_meta_value($page_id, 'header_image')) ? 'style="background-image:url('.sh_get_meta_value($page_id, 'header_image').');"' : '';?>></div> 
		<div class="container">
			<div class="inner-head">
				<div class="inner-title">
					<h2><?php echo (sh_get_meta_value($page_id, 'banner_title')) ? sh_get_meta_value($page_id, 'banner_title') : get_the_title($page_id);?></h2>
					<span><?php echo sh_get_meta_value($page_id, 'sub_title'); ?></span>
				</div>
				<?php echo get_the_breadcrumb();?>
			</div>
		</div>
	</div>
</section>


<section class="block">
	<div class="container">
    	<div class="row">
        	<?php if($sidebar && $layout == 'left'):?>
            	<aside class="col-md-3 slideinright">
                	<div class="top-margin">
						<?php
                                /**
                                 * woocommerce_sidebar hook
                                 *
                                 * @hooked woocommerce_get_sidebar - 10
                                 */
                                do_action('woocommerce_sidebar');
                                dynamic_sidebar($sidebar);
                            ?>
                    </div>
                </aside>
            <?php endif;?>
            <div class="<?php echo ($layout == 'full' || $layout == '') ? 'col-md-12' : 'col-md-9';?>">
            	<?php if(sh_set(sh_set($meta_values, 0), 'title')):?>
            		<?php echo sh_get_section_title(get_the_title($page_id), sh_set(sh_set($meta_values, 0),  'title_tag'), sh_set($settings, 'product_page_title'));?>
                <?php endif;?>
                <div class="top-margin">
					<div class="row">
						<?php
                            /**
                             * woocommerce_before_main_content hook
                             *
                             * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
                             * @hooked woocommerce_breadcrumb - 20
                             */
                            do_action('woocommerce_before_main_content');
                        ?>
                
                        <?php do_action( 'woocommerce_archive_description' ); ?>
                
                        <?php if ( have_posts() ) : ?>
                
                            <?php
                                /**
                                 * woocommerce_before_shop_loop hook
                                 *
                                 * @hooked woocommerce_result_count - 20
                                 * @hooked woocommerce_catalog_ordering - 30
                                 */
                                do_action( 'woocommerce_before_shop_loop' );
                            ?>
                
                            <?php woocommerce_product_loop_start(); ?>
                
                                <?php woocommerce_product_subcategories(); ?>
                                
                                
                                
									<?php //while ( have_posts() ) : the_post(); ?>
                    
                                        <?php 
										 wc_get_template_part( 'content', 'product' );
                                    	?>
                    
                                    <?php //endwhile; // end of the loop. ?>
                                    
                                
                
                            <?php woocommerce_product_loop_end(); ?>
                
                            <?php
                                /**
                                 * woocommerce_after_shop_loop hook
                                 *
                                 * @hooked woocommerce_pagination - 10
                                 */
                                do_action( 'woocommerce_after_shop_loop' );
                            ?>
                
							<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>
                    
                                <?php wc_get_template( 'loop/no-products-found.php' ); ?>
                    
                            <?php endif; ?>
                
						<?php
                            /**
                             * woocommerce_after_main_content hook
                             *
                             * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
                             */
                            do_action('woocommerce_after_main_content');
                        ?>
                	</div>
            	</div>
            </div>
            <?php if( $layout == 'right' ): ?>
				<aside class="col-md-3 slideinright">
                	<div class="top-margin">
						<?php
                            /**
                             * woocommerce_sidebar hook
                             *
                             * @hooked woocommerce_get_sidebar - 10
                             */
                            do_action('woocommerce_sidebar');
                            dynamic_sidebar($sidebar);
                        ?>
                	</div>
				</aside>
            <?php endif; ?>
        </div>
	</div>
</section>

<?php get_footer('shop'); ?>