<?php
/**
 * Cart totals
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     2.4.12
 */
if (!defined('ABSPATH'))
    exit; // Exit if accessed directly
?>
<div class="cart_totals cart-total-box animated bounceIn <?php if (WC()->customer->has_calculated_shipping()) echo 'calculated_shipping'; ?>">

    <?php do_action('woocommerce_before_cart_totals'); ?>

    <div class="cart-head">
        <h2><?php _e('Cart Totals', 'wp_dastak'); ?></h2>
    </div>

    <ul>

        <li class="cart-subtotal">
            <span><?php _e('Cart Subtotal', 'wp_dastak'); ?></span>
            <i><?php wc_cart_totals_subtotal_html(); ?></i>
        </li>

        <?php foreach (WC()->cart->get_coupons('cart') as $code => $coupon) : ?>
            <li class="cart-discount coupon-<?php echo esc_attr($code); ?>">
                <span><?php wc_cart_totals_coupon_label($coupon); ?></span>
                <i><?php wc_cart_totals_coupon_html($coupon); ?></i>
            </li>
        <?php endforeach; ?>

        <?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>

            <li>
                <?php do_action('woocommerce_cart_totals_before_shipping'); ?>
               
                <?php wc_cart_totals_shipping_html(); ?>
               
                <?php do_action('woocommerce_cart_totals_after_shipping'); ?>
            </li>

        <?php endif; ?>

        <?php foreach (WC()->cart->get_fees() as $fee) : ?>
            <li class="fee">
                <span><?php echo esc_html($fee->name); ?></span>
                <i><?php wc_cart_totals_fee_html($fee); ?></i>
            </li>
        <?php endforeach; ?>

        <?php if (WC()->cart->tax_display_cart == 'excl') : ?>
            <?php if (get_option('woocommerce_tax_total_display') == 'itemized') : ?>
                <?php foreach (WC()->cart->get_tax_totals() as $code => $tax) : ?>
                    <li class="tax-rate tax-rate-<?php echo sanitize_title($code); ?>">
                        <span><?php echo esc_html($tax->label); ?></span>
                        <i><?php echo wp_kses_post($tax->formatted_amount); ?></i>
                    </li>
                <?php endforeach; ?>
            <?php else : ?>
                <li class="tax-total">
                    <span><?php echo esc_html(WC()->countries->tax_or_vat()); ?></span>
                    <i><?php echo wc_price(WC()->cart->get_taxes_total()); ?></i>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php foreach (WC()->cart->get_coupons('order') as $code => $coupon) : ?>
            <li class="order-discount coupon-<?php echo esc_attr($code); ?>">
                <span><?php wc_cart_totals_coupon_label($coupon); ?></span>
                <i><?php wc_cart_totals_coupon_html($coupon); ?></i>
            </li>
        <?php endforeach; ?>

        <?php do_action('woocommerce_cart_totals_before_order_total'); ?>

        <li class="order-total">
            <span><?php _e('Order Total', 'wp_dastak'); ?></span>
            <i><?php wc_cart_totals_order_total_html(); ?></i>
        </li>

        <?php do_action('woocommerce_cart_totals_after_order_total'); ?>

    </ul>

    <?php if (WC()->cart->get_cart_tax()) : ?>
        <p><small><?php
                $estimated_text = WC()->customer->is_customer_outside_base() && !WC()->customer->has_calculated_shipping() ? sprintf(' ' . __(' (taxes estimated for %s)', 'wp_dastak'), WC()->countries->estimated_for_prefix() . WC()->countries->countries[WC()->countries->get_base_country()]) : '';

                printf(__('Note: Shipping and taxes are estimated%s and will be updated during checkout based on your billing and shipping information.', 'wp_dastak'), $estimated_text);
                ?></small></p>
            <?php endif; ?>

            <?php do_action('woocommerce_after_cart_totals'); ?>

</div>