<?php
/**
 * Shipping Calculator
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $woocommerce;

if ( get_option( 'woocommerce_enable_shipping_calc' ) === 'no' || ! WC()->cart->needs_shipping() )
	return;
?>

<?php do_action( 'woocommerce_before_shipping_calculator' ); ?>

<form class="shipping_calculator" action="<?php echo esc_url( wc_get_cart_url() ); ?>" method="post">

	<div class="cart-total-box animated bounceIn">
        <div class="cart-head">
        	<h2><a href="#" class="shipping-calculator-button"><?php _e( 'Calculate Shipping', 'wp_dastak' ); ?></a></h2>
        </div>

        <section class="shipping-calculator-form">
    
            <ul>
                <li class="form-ro form-row-wide customlist">
                    <select name="calc_shipping_country" id="calc_shipping_country" class="country_to_state" rel="calc_shipping_state">
                        <option value=""><?php _e( 'Select a country&hellip;', 'wp_dastak' ); ?></option>
                        <?php
                            foreach( WC()->countries->get_shipping_countries() as $key => $value )
                                echo '<option value="' . esc_attr( $key ) . '"' . selected( WC()->customer->get_shipping_country(), esc_attr( $key ), false ) . '>' . esc_html( $value ) . '</option>';
                        ?>
                    </select>
                </li>
        
                <li class="form-ro form-row-wide customlist">
                    <?php
                        $current_cc = WC()->customer->get_shipping_country();
                        $current_r  = WC()->customer->get_shipping_state();
                        $states     = WC()->countries->get_states( $current_cc );
        
                        // Hidden Input
                        if ( is_array( $states ) && empty( $states ) ) {
        
                            ?><input type="hidden" name="calc_shipping_state" id="calc_shipping_state" placeholder="<?php _e( 'State / county', 'wp_dastak' ); ?>" /><?php
        
                        // Dropdown Input
                        } elseif ( is_array( $states ) ) {
        
                            ?><span>
                                <select name="calc_shipping_state" id="calc_shipping_state" placeholder="<?php _e( 'State / county', 'wp_dastak' ); ?>">
                                    <option value=""><?php _e( 'Select a state&hellip;', 'wp_dastak' ); ?></option>
                                    <?php
                                        foreach ( $states as $ckey => $cvalue )
                                            echo '<option value="' . esc_attr( $ckey ) . '" ' . selected( $current_r, $ckey, false ) . '>' .esc_html( $cvalue ) .'</option>';
                                    ?>
                                </select>
                            </span><?php
        
                        // Standard Input
                        } else {
        
                            ?><input type="text" class="input-text" value="<?php echo esc_attr( $current_r ); ?>" placeholder="<?php _e( 'State / county', 'wp_dastak' ); ?>" name="calc_shipping_state" id="calc_shipping_state" /><?php
        
                        }
                    ?>
                </li>
        
                <?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_city', false ) ) : ?>
        
                    <li class="form-ro form-row-wide">
                        <input type="text" class="input-text" value="<?php echo esc_attr( WC()->customer->get_shipping_city() ); ?>" placeholder="<?php _e( 'City', 'wp_dastak' ); ?>" name="calc_shipping_city" id="calc_shipping_city" />
                    </li>
        
                <?php endif; ?>
        
                <?php if ( apply_filters( 'woocommerce_shipping_calculator_enable_postcode', true ) ) : ?>
        
                    <li class="form-ro form-row-wide">
                        <input type="text" class="input-text" value="<?php echo esc_attr( WC()->customer->get_shipping_postcode() ); ?>" placeholder="<?php _e( 'Postcode / Zip', 'wp_dastak' ); ?>" name="calc_shipping_postcode" id="calc_shipping_postcode" />
                    </li>
        
                <?php endif; ?>
        
                <li><button type="submit" name="calc_shipping" value="1" class="button"><?php _e( 'Update Totals', 'wp_dastak' ); ?></button></li>
        
                <?php wp_nonce_field( 'woocommerce-cart' ); ?>
            
            </ul>
        </section>
    </div>
</form>

<?php do_action( 'woocommerce_after_shipping_calculator' ); ?>